package fr.ifremer.isisfish.entities;

import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class SetOfVesselsDAOAbstract<E extends SetOfVessels> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)SetOfVessels.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
                {
                List<fr.ifremer.isisfish.entities.Strategy> list = getContext()
                            .getDAO(fr.ifremer.isisfish.entities.Strategy.class)
                            .findAllByProperties("setOfVessels", entity);
                    for (fr.ifremer.isisfish.entities.Strategy item : list) {
                        item.setSetOfVessels(null);

                    }
                }

        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty("name", v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty("name", v);
        return result;
    }

    /**
     * findByNumberOfVessels :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut numberOfVessels le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByNumberOfVessels(int v) throws TopiaException {
        E result = findByProperty("numberOfVessels", v);
        return result;
    }

    /**
     * findAllByNumberOfVessels :
     * Retourne les éléments ayant comme valeur pour l'attribut numberOfVessels le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByNumberOfVessels(int v) throws TopiaException {
        List<E> result = findAllByProperty("numberOfVessels", v);
        return result;
    }

    /**
     * findByFixedCosts :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut fixedCosts le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByFixedCosts(double v) throws TopiaException {
        E result = findByProperty("fixedCosts", v);
        return result;
    }

    /**
     * findAllByFixedCosts :
     * Retourne les éléments ayant comme valeur pour l'attribut fixedCosts le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByFixedCosts(double v) throws TopiaException {
        List<E> result = findAllByProperty("fixedCosts", v);
        return result;
    }

    /**
     * findByVesselCosts :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut vesselCosts le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByVesselCosts(double v) throws TopiaException {
        E result = findByProperty("vesselCosts", v);
        return result;
    }

    /**
     * findAllByVesselCosts :
     * Retourne les éléments ayant comme valeur pour l'attribut vesselCosts le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByVesselCosts(double v) throws TopiaException {
        List<E> result = findAllByProperty("vesselCosts", v);
        return result;
    }

    /**
     * findByCapitalDeprecation :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut capitalDeprecation le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCapitalDeprecation(double v) throws TopiaException {
        E result = findByProperty("capitalDeprecation", v);
        return result;
    }

    /**
     * findAllByCapitalDeprecation :
     * Retourne les éléments ayant comme valeur pour l'attribut capitalDeprecation le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCapitalDeprecation(double v) throws TopiaException {
        List<E> result = findAllByProperty("capitalDeprecation", v);
        return result;
    }

    /**
     * findByInterestCost :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut interestCost le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByInterestCost(double v) throws TopiaException {
        E result = findByProperty("interestCost", v);
        return result;
    }

    /**
     * findAllByInterestCost :
     * Retourne les éléments ayant comme valeur pour l'attribut interestCost le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByInterestCost(double v) throws TopiaException {
        List<E> result = findAllByProperty("interestCost", v);
        return result;
    }

    /**
     * findByComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty("comment", v);
        return result;
    }

    /**
     * findAllByComment :
     * Retourne les éléments ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty("comment", v);
        return result;
    }

    /**
     * findByTechnicalEfficiencyEquation :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut technicalEfficiencyEquation le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByTechnicalEfficiencyEquation(Equation v) throws TopiaException {
        E result = findByProperty("technicalEfficiencyEquation", v);
        return result;
    }

    /**
     * findAllByTechnicalEfficiencyEquation :
     * Retourne les éléments ayant comme valeur pour l'attribut technicalEfficiencyEquation le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByTechnicalEfficiencyEquation(Equation v) throws TopiaException {
        List<E> result = findAllByProperty("technicalEfficiencyEquation", v);
        return result;
    }

    /**
     * findByPort :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut port le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByPort(Port v) throws TopiaException {
        E result = findByProperty("port", v);
        return result;
    }

    /**
     * findAllByPort :
     * Retourne les éléments ayant comme valeur pour l'attribut port le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByPort(Port v) throws TopiaException {
        List<E> result = findAllByProperty("port", v);
        return result;
    }

    /**
     * findContainsPossibleMetiers :
     * Retourne le premier élément trouvé dont l'attribut possibleMetiers contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsPossibleMetiers(Metier... v) throws TopiaException {
        E result = findContainsProperties("possibleMetiers", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsPossibleMetiers :
     * Retourne les éléments trouvé dont l'attribut possibleMetiers contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsPossibleMetiers(Metier... v) throws TopiaException {
        List<E> results = findAllContainsProperties("possibleMetiers", Arrays.asList(v));
        return results;
    }

    /**
     * findByVesselType :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut vesselType le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByVesselType(VesselType v) throws TopiaException {
        E result = findByProperty("vesselType", v);
        return result;
    }

    /**
     * findAllByVesselType :
     * Retourne les éléments ayant comme valeur pour l'attribut vesselType le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByVesselType(VesselType v) throws TopiaException {
        List<E> result = findAllByProperty("vesselType", v);
        return result;
    }


} //SetOfVesselsDAOAbstract<E extends SetOfVessels>
