package fr.ifremer.isisfish.entities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class SetOfVesselsAbstract extends TopiaEntityAbstract implements SetOfVessels {

    private String name;
    private int numberOfVessels;
    /**
     * <p>Co&ucirc;ts fixes d&eacute;caiss&eacute;s</p>


     */
    private double fixedCosts;
    private double vesselCosts;
    private double capitalDeprecation;
    private double interestCost;
    private String comment;
    public Equation technicalEfficiencyEquation;
    public Port port;
    public Collection<EffortDescription> possibleMetiers;
    public VesselType vesselType;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(SetOfVessels.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(SetOfVessels.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "name", String.class, name);
        visitor.visit(this, "numberOfVessels", int.class, numberOfVessels);
        visitor.visit(this, "fixedCosts", double.class, fixedCosts);
        visitor.visit(this, "vesselCosts", double.class, vesselCosts);
        visitor.visit(this, "capitalDeprecation", double.class, capitalDeprecation);
        visitor.visit(this, "interestCost", double.class, interestCost);
        visitor.visit(this, "comment", String.class, comment);
        visitor.visit(this, "technicalEfficiencyEquation", Equation.class, technicalEfficiencyEquation);
        visitor.visit(this, "port", Port.class, port);
        visitor.visit(this, "possibleMetiers", java.util.Collection.class, EffortDescription.class, possibleMetiers);
        visitor.visit(this, "vesselType", VesselType.class, vesselType);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        tmp.add(getTechnicalEfficiencyEquation());

        {
            org.nuiton.topia.persistence.TopiaDAO<EffortDescription> dao = ((TopiaContextImplementor) getTopiaContext()).getDAO(EffortDescription.class);
            List<EffortDescription> findAllByProperties = dao.findAllByProperties("setOfVessels", this);
            if (findAllByProperties != null) {
                tmp.addAll(findAllByProperties);
            }
        }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        fireOnPostWrite("name", _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead("name", name);
        String result = this.name;
        fireOnPostRead("name", name);
        return result;
}

    /**
     * setNumberOfVessels :
     * @param value 
     */

    public void setNumberOfVessels(int value) {
        int _oldValue = this.numberOfVessels;
        fireOnPreWrite("numberOfVessels", _oldValue, value);
        this.numberOfVessels = value;
        fireOnPostWrite("numberOfVessels", _oldValue, value);
}

    /**
     * getNumberOfVessels :
     * @return int 
     */

    public int getNumberOfVessels() {
        fireOnPreRead("numberOfVessels", numberOfVessels);
        int result = this.numberOfVessels;
        fireOnPostRead("numberOfVessels", numberOfVessels);
        return result;
}

    /**
     * setFixedCosts :
     * @param value 
     */

    public void setFixedCosts(double value) {
        double _oldValue = this.fixedCosts;
        fireOnPreWrite("fixedCosts", _oldValue, value);
        this.fixedCosts = value;
        fireOnPostWrite("fixedCosts", _oldValue, value);
}

    /**
     * getFixedCosts :
     * @return double 
     */

    public double getFixedCosts() {
        fireOnPreRead("fixedCosts", fixedCosts);
        double result = this.fixedCosts;
        fireOnPostRead("fixedCosts", fixedCosts);
        return result;
}

    /**
     * setVesselCosts :
     * @param value 
     */

    public void setVesselCosts(double value) {
        double _oldValue = this.vesselCosts;
        fireOnPreWrite("vesselCosts", _oldValue, value);
        this.vesselCosts = value;
        fireOnPostWrite("vesselCosts", _oldValue, value);
}

    /**
     * getVesselCosts :
     * @return double 
     */

    public double getVesselCosts() {
        fireOnPreRead("vesselCosts", vesselCosts);
        double result = this.vesselCosts;
        fireOnPostRead("vesselCosts", vesselCosts);
        return result;
}

    /**
     * setCapitalDeprecation :
     * @param value 
     */

    public void setCapitalDeprecation(double value) {
        double _oldValue = this.capitalDeprecation;
        fireOnPreWrite("capitalDeprecation", _oldValue, value);
        this.capitalDeprecation = value;
        fireOnPostWrite("capitalDeprecation", _oldValue, value);
}

    /**
     * getCapitalDeprecation :
     * @return double 
     */

    public double getCapitalDeprecation() {
        fireOnPreRead("capitalDeprecation", capitalDeprecation);
        double result = this.capitalDeprecation;
        fireOnPostRead("capitalDeprecation", capitalDeprecation);
        return result;
}

    /**
     * setInterestCost :
     * @param value 
     */

    public void setInterestCost(double value) {
        double _oldValue = this.interestCost;
        fireOnPreWrite("interestCost", _oldValue, value);
        this.interestCost = value;
        fireOnPostWrite("interestCost", _oldValue, value);
}

    /**
     * getInterestCost :
     * @return double 
     */

    public double getInterestCost() {
        fireOnPreRead("interestCost", interestCost);
        double result = this.interestCost;
        fireOnPostRead("interestCost", interestCost);
        return result;
}

    /**
     * setComment :
     * @param value 
     */

    public void setComment(String value) {
        String _oldValue = this.comment;
        fireOnPreWrite("comment", _oldValue, value);
        this.comment = value;
        fireOnPostWrite("comment", _oldValue, value);
}

    /**
     * getComment :
     * @return String 
     */

    public String getComment() {
        fireOnPreRead("comment", comment);
        String result = this.comment;
        fireOnPostRead("comment", comment);
        return result;
}

    /**
     * setTechnicalEfficiencyEquation :
     * @param value 
     */

    public void setTechnicalEfficiencyEquation(Equation value) {
        Equation _oldValue = this.technicalEfficiencyEquation;
        fireOnPreWrite("technicalEfficiencyEquation", _oldValue, value);
        this.technicalEfficiencyEquation = value;
        fireOnPostWrite("technicalEfficiencyEquation", _oldValue, value);
}

    /**
     * getTechnicalEfficiencyEquation :
     * @return Equation 
     */

    public Equation getTechnicalEfficiencyEquation() {
        fireOnPreRead("technicalEfficiencyEquation", technicalEfficiencyEquation);
        Equation result = this.technicalEfficiencyEquation;
        fireOnPostRead("technicalEfficiencyEquation", technicalEfficiencyEquation);
        return result;
}

    /**
     * setPort :
     * @param value 
     */

    public void setPort(Port value) {
        Port _oldValue = this.port;
        fireOnPreWrite("port", _oldValue, value);
        this.port = value;
        fireOnPostWrite("port", _oldValue, value);
}

    /**
     * getPort :
     * @return Port 
     */

    public Port getPort() {
        fireOnPreRead("port", port);
        Port result = this.port;
        fireOnPostRead("port", port);
        return result;
}

    /**
     * addPossibleMetiers :
     * @param value 
     */

    public void addPossibleMetiers(EffortDescription value) {
        fireOnPreWrite("possibleMetiers", null, value);
        if (this.possibleMetiers == null) {
            this.possibleMetiers = new ArrayList<fr.ifremer.isisfish.entities.EffortDescription>();
        }
        this.possibleMetiers.add(value);
        fireOnPostWrite("possibleMetiers", this.possibleMetiers.size(), null, value);
}

    /**
     * getPossibleMetiersByTopiaId :
     * @param topiaId 
     * @return EffortDescription 
     */

    public EffortDescription getPossibleMetiersByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(possibleMetiers, topiaId);
}

    /**
     * addAllPossibleMetiers :
     * @param values 
     */

    public void addAllPossibleMetiers(Collection<EffortDescription> values) {
        if (values == null) {
            return;
        }
        for (fr.ifremer.isisfish.entities.EffortDescription item : values) {
            addPossibleMetiers(item);
        }
}

    /**
     * setPossibleMetiers :
     * @param values 
     */

    public void setPossibleMetiers(Collection<EffortDescription> values) {
//        clearPossibleMetiers();
//        addAllPossibleMetiers(values);
// FIXME
        Collection<fr.ifremer.isisfish.entities.EffortDescription> _oldValue = possibleMetiers;
        fireOnPreWrite("possibleMetiers", _oldValue, values);
        possibleMetiers = values;
        fireOnPostWrite("possibleMetiers", _oldValue, values);
}

    /**
     * removePossibleMetiers :
     * @param value 
     */

    public void removePossibleMetiers(EffortDescription value) {
        fireOnPreWrite("possibleMetiers", value, null);
        if ((this.possibleMetiers == null) || (!this.possibleMetiers.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        fireOnPostWrite("possibleMetiers", this.possibleMetiers.size()+1, value, null);
}

    /**
     * clearPossibleMetiers :
     */

    public void clearPossibleMetiers() {
        if (this.possibleMetiers == null) {
            return;
        }
        Collection<fr.ifremer.isisfish.entities.EffortDescription> _oldValue = new ArrayList<fr.ifremer.isisfish.entities.EffortDescription>(this.possibleMetiers);
        fireOnPreWrite("possibleMetiers", _oldValue, null);
        this.possibleMetiers.clear();
        fireOnPostWrite("possibleMetiers", _oldValue, null);
}

    /**
     * getPossibleMetiers :
     * @return Collection<EffortDescription> 
     */

    public Collection<EffortDescription> getPossibleMetiers() {
        return possibleMetiers;
}

    /**
     * getPossibleMetiers :
     * @param value 
     * @return EffortDescription 
     */

    public EffortDescription getPossibleMetiers(Metier value) {
        if (value == null || possibleMetiers == null) {
            return null;
        }
        for (fr.ifremer.isisfish.entities.EffortDescription item : possibleMetiers) {
            if (value.equals(item.getPossibleMetiers())) {
                return item;
            }
        }
        return null;
}

    /**
     * sizePossibleMetiers :
     * @return int 
     */

    public int sizePossibleMetiers() {
        if (possibleMetiers == null) {
            return 0;
        }
        return possibleMetiers.size();
}

    /**
     * isPossibleMetiersEmpty :
     * @return boolean 
     */

    public boolean isPossibleMetiersEmpty() {
        int size = sizePossibleMetiers();
        return size == 0;
}

    /**
     * setVesselType :
     * @param value 
     */

    public void setVesselType(VesselType value) {
        VesselType _oldValue = this.vesselType;
        fireOnPreWrite("vesselType", _oldValue, value);
        this.vesselType = value;
        fireOnPostWrite("vesselType", _oldValue, value);
}

    /**
     * getVesselType :
     * @return VesselType 
     */

    public VesselType getVesselType() {
        fireOnPreRead("vesselType", vesselType);
        VesselType result = this.vesselType;
        fireOnPostRead("vesselType", vesselType);
        return result;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
            append("numberOfVessels", this.numberOfVessels).
            append("fixedCosts", this.fixedCosts).
            append("vesselCosts", this.vesselCosts).
            append("capitalDeprecation", this.capitalDeprecation).
            append("interestCost", this.interestCost).
            append("comment", this.comment).
            append("technicalEfficiencyEquation", this.technicalEfficiencyEquation).
            append("port", this.port).
            append("vesselType", this.vesselType).
         toString();
        return result;
}


} //SetOfVesselsAbstract
