package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.Date;
import java.util.Collection;
import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields (
  txtFields={"name","comment"},
  numFields={"numberOfVessels","fixedCosts","vesselCosts","capitalDeprecation","interestCost"}
)

public interface SetOfVessels extends TopiaEntity {     String NAME = "name";
     String NUMBER_OF_VESSELS = "numberOfVessels";
     String FIXED_COSTS = "fixedCosts";
     String VESSEL_COSTS = "vesselCosts";
     String CAPITAL_DEPRECATION = "capitalDeprecation";
     String INTEREST_COST = "interestCost";
     String COMMENT = "comment";
     String TECHNICAL_EFFICIENCY_EQUATION = "technicalEfficiencyEquation";
     String PORT = "port";
     String POSSIBLE_METIERS = "possibleMetiers";
     String VESSEL_TYPE = "vesselType";
    /**
     * setName :
     * @param name La valeur de l'attribut name à positionner.
     */

     void setName(String name);

    /**
     * getName :
     * @return String 
     */

     String getName();

    /**
     * setNumberOfVessels :
     * @param numberOfVessels La valeur de l'attribut numberOfVessels à positionner.
     */

     void setNumberOfVessels(int numberOfVessels);

    /**
     * getNumberOfVessels :
     * @return int 
     */

     int getNumberOfVessels();

    /**
     * setFixedCosts :
     * <p>Co&ucirc;ts fixes d&eacute;caiss&eacute;s</p>

     * @param fixedCosts La valeur de l'attribut fixedCosts à positionner.
     */

     void setFixedCosts(double fixedCosts);

    /**
     * getFixedCosts :
     * <p>Co&ucirc;ts fixes d&eacute;caiss&eacute;s</p>

     * @return double 
     */

     double getFixedCosts();

    /**
     * setVesselCosts :
     * @param vesselCosts La valeur de l'attribut vesselCosts à positionner.
     */

     void setVesselCosts(double vesselCosts);

    /**
     * getVesselCosts :
     * @return double 
     */

     double getVesselCosts();

    /**
     * setCapitalDeprecation :
     * @param capitalDeprecation La valeur de l'attribut capitalDeprecation à positionner.
     */

     void setCapitalDeprecation(double capitalDeprecation);

    /**
     * getCapitalDeprecation :
     * @return double 
     */

     double getCapitalDeprecation();

    /**
     * setInterestCost :
     * @param interestCost La valeur de l'attribut interestCost à positionner.
     */

     void setInterestCost(double interestCost);

    /**
     * getInterestCost :
     * @return double 
     */

     double getInterestCost();

    /**
     * setComment :
     * @param comment La valeur de l'attribut comment à positionner.
     */

     void setComment(String comment);

    /**
     * getComment :
     * @return String 
     */

     String getComment();

    /**
     * setTechnicalEfficiencyEquation :
     * @param technicalEfficiencyEquation La valeur de l'attribut technicalEfficiencyEquation à positionner.
     */

     void setTechnicalEfficiencyEquation(Equation technicalEfficiencyEquation);

    /**
     * getTechnicalEfficiencyEquation :
     * @return Equation 
     */

     Equation getTechnicalEfficiencyEquation();

    /**
     * setPort :
     * @param port La valeur de l'attribut port à positionner.
     */

     void setPort(Port port);

    /**
     * getPort :
     * @return Port 
     */

     Port getPort();

    /**
     * addPossibleMetiers :
     * @param effortDescription L'instance de EffortDescription à ajouter
     */

     void addPossibleMetiers(EffortDescription effortDescription);

    /**
     * addAllPossibleMetiers :
     * @param effortDescription Les instances de EffortDescription à ajouter
     */

     void addAllPossibleMetiers(Collection<EffortDescription> effortDescription);

    /**
     * setPossibleMetiers :
     * @param effortDescription La Collection de EffortDescription à ajouter
     */

     void setPossibleMetiers(Collection<EffortDescription> effortDescription);

    /**
     * removePossibleMetiers :
     * @param effortDescription L'instance de EffortDescription à retirer
     */

     void removePossibleMetiers(EffortDescription effortDescription);

    /**
     * clearPossibleMetiers :
     * Vide la Collection de EffortDescription .
     */

     void clearPossibleMetiers();

    /**
     * getPossibleMetiers :
     * @return Collection<EffortDescription> 
     */

     Collection<EffortDescription> getPossibleMetiers();

    /**
     * getPossibleMetiersByTopiaId :
     * Recupère l'attribut possibleMetiers à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return EffortDescription 
     */

     EffortDescription getPossibleMetiersByTopiaId(String topiaId);

    /**
     * getPossibleMetiers :
     * @param value 
     * @return EffortDescription 
     */

     EffortDescription getPossibleMetiers(Metier value);

    /**
     * sizePossibleMetiers :
     * @return int 
     */

     int sizePossibleMetiers();

    /**
     * isPossibleMetiersEmpty :
     * @return boolean 
     */

     boolean isPossibleMetiersEmpty();

    /**
     * setVesselType :
     * @param vesselType La valeur de l'attribut vesselType à positionner.
     */

     void setVesselType(VesselType vesselType);

    /**
     * getVesselType :
     * @return VesselType 
     */

     VesselType getVesselType();

    /**
     * getFisheryRegion :
     * @return FisheryRegion 
     */

     FisheryRegion getFisheryRegion();

    /**
     * getTechnicalEfficiency :
     * @param date 
     * @param metier 
     * @return double 
     */

     double getTechnicalEfficiency(Date date, Metier metier);


} //SetOfVessels
