package fr.ifremer.isisfish.entities;

import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class SelectivityDAOAbstract<E extends Selectivity> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Selectivity.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByEquation :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut equation le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByEquation(Equation v) throws TopiaException {
        E result = findByProperty("equation", v);
        return result;
    }

    /**
     * findAllByEquation :
     * Retourne les éléments ayant comme valeur pour l'attribut equation le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByEquation(Equation v) throws TopiaException {
        List<E> result = findAllByProperty("equation", v);
        return result;
    }

    /**
     * findContainsGear :
     * Retourne le premier élément trouvé dont l'attribut gear contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsGear(Gear... v) throws TopiaException {
        E result = findContainsProperties("gear", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsGear :
     * Retourne les éléments trouvé dont l'attribut gear contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsGear(Gear... v) throws TopiaException {
        List<E> results = findAllContainsProperties("gear", Arrays.asList(v));
        return results;
    }

    /**
     * findContainsPopulation :
     * Retourne le premier élément trouvé dont l'attribut population contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsPopulation(Population... v) throws TopiaException {
        E result = findContainsProperties("population", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsPopulation :
     * Retourne les éléments trouvé dont l'attribut population contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsPopulation(Population... v) throws TopiaException {
        List<E> results = findAllContainsProperties("population", Arrays.asList(v));
        return results;
    }


} //SelectivityDAOAbstract<E extends Selectivity>
