package fr.ifremer.isisfish.entities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class SelectivityAbstract extends TopiaEntityAbstract implements Selectivity {

    private Equation equation;
    public Gear gear;
    public Population population;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Selectivity.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Selectivity.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "equation", Equation.class, equation);
        visitor.visit(this, "gear", Gear.class, gear);
        visitor.visit(this, "population", Population.class, population);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        tmp.add(getEquation());

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setEquation :
     * @param value 
     */

    public void setEquation(Equation value) {
        Equation _oldValue = this.equation;
        fireOnPreWrite("equation", _oldValue, value);
        this.equation = value;
        fireOnPostWrite("equation", _oldValue, value);
}

    /**
     * getEquation :
     * @return Equation 
     */

    public Equation getEquation() {
        fireOnPreRead("equation", equation);
        Equation result = this.equation;
        fireOnPostRead("equation", equation);
        return result;
}

    /**
     * setGear :
     * @param value La valeur de l'attribut gear à positionner.
     */

    public void setGear(Gear value) {
        Gear _oldValue = this.gear;
        fireOnPreWrite("gear", _oldValue, value);
        this.gear = value;
        fireOnPostWrite("gear", _oldValue, value);
}

    /**
     * getGear :
     * @return Gear 
     */

    public Gear getGear() {    
        return gear;
}

    /**
     * setPopulation :
     * @param value La valeur de l'attribut population à positionner.
     */

    public void setPopulation(Population value) {
        Population _oldValue = this.population;
        fireOnPreWrite("population", _oldValue, value);
        this.population = value;
        fireOnPostWrite("population", _oldValue, value);
}

    /**
     * getPopulation :
     * @return Population 
     */

    public Population getPopulation() {    
        return population;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("equation", this.equation).
         toString();
        return result;
}


} //SelectivityAbstract
