package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.IsisFishException;
import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields ()

public interface Selectivity extends TopiaEntity {     String EQUATION = "equation";
     String GEAR = "gear";
     String POPULATION = "population";
    /**
     * setEquation :
     * @param equation La valeur de l'attribut equation à positionner.
     */

     void setEquation(Equation equation);

    /**
     * getEquation :
     * @return Equation 
     */

     Equation getEquation();

    /**
     * setGear :
     * @param value La valeur de l'attribut gear à positionner.
     */

     void setGear(Gear value);

    /**
     * getGear :
     * Retourne la valeur de l'attribut gear.
     * @return Gear 
     */

     Gear getGear();

    /**
     * setPopulation :
     * @param value La valeur de l'attribut population à positionner.
     */

     void setPopulation(Population value);

    /**
     * getPopulation :
     * Retourne la valeur de l'attribut population.
     * @return Population 
     */

     Population getPopulation();

    /**
     * getCoefficient :
     * @param pop 
     * @param group 
     * @param metier 
     * @return double 
     * @throws IsisFishException
     */

     double getCoefficient(Population pop, PopulationGroup group, Metier metier) throws IsisFishException;


} //Selectivity
