package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.Month;
import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class SeasonDAOAbstract<E extends Season> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Season.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByFirstMonth :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut firstMonth le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByFirstMonth(Month v) throws TopiaException {
        E result = findByProperty("firstMonth", v);
        return result;
    }

    /**
     * findAllByFirstMonth :
     * Retourne les éléments ayant comme valeur pour l'attribut firstMonth le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByFirstMonth(Month v) throws TopiaException {
        List<E> result = findAllByProperty("firstMonth", v);
        return result;
    }

    /**
     * findByLastMonth :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut lastMonth le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByLastMonth(Month v) throws TopiaException {
        E result = findByProperty("lastMonth", v);
        return result;
    }

    /**
     * findAllByLastMonth :
     * Retourne les éléments ayant comme valeur pour l'attribut lastMonth le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByLastMonth(Month v) throws TopiaException {
        List<E> result = findAllByProperty("lastMonth", v);
        return result;
    }


} //SeasonDAOAbstract<E extends Season>
