package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.Month;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class SeasonAbstract extends TopiaEntityAbstract implements Season {

    public Month firstMonth;
    public Month lastMonth;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Season.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Season.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "firstMonth", Month.class, firstMonth);
        visitor.visit(this, "lastMonth", Month.class, lastMonth);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setFirstMonth :
     * @param value 
     */

    public void setFirstMonth(Month value) {
        Month _oldValue = this.firstMonth;
        fireOnPreWrite("firstMonth", _oldValue, value);
        this.firstMonth = value;
        fireOnPostWrite("firstMonth", _oldValue, value);
}

    /**
     * getFirstMonth :
     * @return Month 
     */

    public Month getFirstMonth() {
        fireOnPreRead("firstMonth", firstMonth);
        Month result = this.firstMonth;
        fireOnPostRead("firstMonth", firstMonth);
        return result;
}

    /**
     * setLastMonth :
     * @param value 
     */

    public void setLastMonth(Month value) {
        Month _oldValue = this.lastMonth;
        fireOnPreWrite("lastMonth", _oldValue, value);
        this.lastMonth = value;
        fireOnPostWrite("lastMonth", _oldValue, value);
}

    /**
     * getLastMonth :
     * @return Month 
     */

    public Month getLastMonth() {
        fireOnPreRead("lastMonth", lastMonth);
        Month result = this.lastMonth;
        fireOnPostRead("lastMonth", lastMonth);
        return result;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("firstMonth", this.firstMonth).
            append("lastMonth", this.lastMonth).
         toString();
        return result;
}


} //SeasonAbstract
