package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.Date;
import java.util.Arrays;
import java.util.List;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class ResultDAOAbstract<E extends Result> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Result.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByResultDate :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut resultDate le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByResultDate(Date v) throws TopiaException {
        E result = findByProperty("resultDate", v);
        return result;
    }

    /**
     * findAllByResultDate :
     * Retourne les éléments ayant comme valeur pour l'attribut resultDate le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByResultDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty("resultDate", v);
        return result;
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty("name", v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty("name", v);
        return result;
    }

    /**
     * findByMatrix :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut matrix le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMatrix(MatrixND v) throws TopiaException {
        E result = findByProperty("matrix", v);
        return result;
    }

    /**
     * findAllByMatrix :
     * Retourne les éléments ayant comme valeur pour l'attribut matrix le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMatrix(MatrixND v) throws TopiaException {
        List<E> result = findAllByProperty("matrix", v);
        return result;
    }


} //ResultDAOAbstract<E extends Result>
