package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.Date;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class ResultAbstract extends TopiaEntityAbstract implements Result {

    private Date resultDate;
    /**
     * <p>Contient la description associ&eacute; &agrave; un type.</p>


     */
    private String name;
    /**
     * <p>contient les matrices associ&eacute;es &agrave; chaque type de r&eacute;sultat. La cle est un type et la valeur une matrice</p>


     */
    private MatrixND matrix;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Result.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Result.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "resultDate", Date.class, resultDate);
        visitor.visit(this, "name", String.class, name);
        visitor.visit(this, "matrix", MatrixND.class, matrix);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setResultDate :
     * @param value 
     */

    public void setResultDate(Date value) {
        Date _oldValue = this.resultDate;
        fireOnPreWrite("resultDate", _oldValue, value);
        this.resultDate = value;
        fireOnPostWrite("resultDate", _oldValue, value);
}

    /**
     * getResultDate :
     * @return Date 
     */

    public Date getResultDate() {
        fireOnPreRead("resultDate", resultDate);
        Date result = this.resultDate;
        fireOnPostRead("resultDate", resultDate);
        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        fireOnPostWrite("name", _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead("name", name);
        String result = this.name;
        fireOnPostRead("name", name);
        return result;
}

    /**
     * setMatrix :
     * @param value 
     */

    public void setMatrix(MatrixND value) {
        MatrixND _oldValue = this.matrix;
        fireOnPreWrite("matrix", _oldValue, value);
        this.matrix = value;
        fireOnPostWrite("matrix", _oldValue, value);
}

    /**
     * getMatrix :
     * @return MatrixND 
     */

    public MatrixND getMatrix() {
        fireOnPreRead("matrix", matrix);
        MatrixND result = this.matrix;
        fireOnPostRead("matrix", matrix);
        return result;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("resultDate", this.resultDate).
            append("name", this.name).
            append("matrix", this.matrix).
         toString();
        return result;
}


} //ResultAbstract
