package fr.ifremer.isisfish.entities;

import java.util.Arrays;
import java.util.List;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;


public abstract class PopulationSeasonInfoDAOAbstract<E extends PopulationSeasonInfo> extends SeasonDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)PopulationSeasonInfo.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByReproductionDistribution :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut reproductionDistribution le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByReproductionDistribution(MatrixND v) throws TopiaException {
        E result = findByProperty("reproductionDistribution", v);
        return result;
    }

    /**
     * findAllByReproductionDistribution :
     * Retourne les éléments ayant comme valeur pour l'attribut reproductionDistribution le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByReproductionDistribution(MatrixND v) throws TopiaException {
        List<E> result = findAllByProperty("reproductionDistribution", v);
        return result;
    }

    /**
     * findByGroupChange :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut groupChange le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByGroupChange(boolean v) throws TopiaException {
        E result = findByProperty("groupChange", v);
        return result;
    }

    /**
     * findAllByGroupChange :
     * Retourne les éléments ayant comme valeur pour l'attribut groupChange le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByGroupChange(boolean v) throws TopiaException {
        List<E> result = findAllByProperty("groupChange", v);
        return result;
    }

    /**
     * findBySimpleLengthChangeMatrix :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut simpleLengthChangeMatrix le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findBySimpleLengthChangeMatrix(boolean v) throws TopiaException {
        E result = findByProperty("simpleLengthChangeMatrix", v);
        return result;
    }

    /**
     * findAllBySimpleLengthChangeMatrix :
     * Retourne les éléments ayant comme valeur pour l'attribut simpleLengthChangeMatrix le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllBySimpleLengthChangeMatrix(boolean v) throws TopiaException {
        List<E> result = findAllByProperty("simpleLengthChangeMatrix", v);
        return result;
    }

    /**
     * findByLengthChangeMatrix :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut lengthChangeMatrix le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByLengthChangeMatrix(MatrixND v) throws TopiaException {
        E result = findByProperty("lengthChangeMatrix", v);
        return result;
    }

    /**
     * findAllByLengthChangeMatrix :
     * Retourne les éléments ayant comme valeur pour l'attribut lengthChangeMatrix le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByLengthChangeMatrix(MatrixND v) throws TopiaException {
        List<E> result = findAllByProperty("lengthChangeMatrix", v);
        return result;
    }

    /**
     * findByReproduction :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut reproduction le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByReproduction(boolean v) throws TopiaException {
        E result = findByProperty("reproduction", v);
        return result;
    }

    /**
     * findAllByReproduction :
     * Retourne les éléments ayant comme valeur pour l'attribut reproduction le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByReproduction(boolean v) throws TopiaException {
        List<E> result = findAllByProperty("reproduction", v);
        return result;
    }

    /**
     * findByUseEquationMigration :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut useEquationMigration le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByUseEquationMigration(boolean v) throws TopiaException {
        E result = findByProperty("useEquationMigration", v);
        return result;
    }

    /**
     * findAllByUseEquationMigration :
     * Retourne les éléments ayant comme valeur pour l'attribut useEquationMigration le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByUseEquationMigration(boolean v) throws TopiaException {
        List<E> result = findAllByProperty("useEquationMigration", v);
        return result;
    }

    /**
     * findByMigrationMatrix :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut migrationMatrix le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMigrationMatrix(MatrixND v) throws TopiaException {
        E result = findByProperty("migrationMatrix", v);
        return result;
    }

    /**
     * findAllByMigrationMatrix :
     * Retourne les éléments ayant comme valeur pour l'attribut migrationMatrix le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMigrationMatrix(MatrixND v) throws TopiaException {
        List<E> result = findAllByProperty("migrationMatrix", v);
        return result;
    }

    /**
     * findByEmigrationMatrix :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut emigrationMatrix le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByEmigrationMatrix(MatrixND v) throws TopiaException {
        E result = findByProperty("emigrationMatrix", v);
        return result;
    }

    /**
     * findAllByEmigrationMatrix :
     * Retourne les éléments ayant comme valeur pour l'attribut emigrationMatrix le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByEmigrationMatrix(MatrixND v) throws TopiaException {
        List<E> result = findAllByProperty("emigrationMatrix", v);
        return result;
    }

    /**
     * findByImmigrationMatrix :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut immigrationMatrix le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByImmigrationMatrix(MatrixND v) throws TopiaException {
        E result = findByProperty("immigrationMatrix", v);
        return result;
    }

    /**
     * findAllByImmigrationMatrix :
     * Retourne les éléments ayant comme valeur pour l'attribut immigrationMatrix le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByImmigrationMatrix(MatrixND v) throws TopiaException {
        List<E> result = findAllByProperty("immigrationMatrix", v);
        return result;
    }

    /**
     * findByMigrationEquation :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut migrationEquation le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMigrationEquation(Equation v) throws TopiaException {
        E result = findByProperty("migrationEquation", v);
        return result;
    }

    /**
     * findAllByMigrationEquation :
     * Retourne les éléments ayant comme valeur pour l'attribut migrationEquation le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMigrationEquation(Equation v) throws TopiaException {
        List<E> result = findAllByProperty("migrationEquation", v);
        return result;
    }

    /**
     * findByEmigrationEquation :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut emigrationEquation le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByEmigrationEquation(Equation v) throws TopiaException {
        E result = findByProperty("emigrationEquation", v);
        return result;
    }

    /**
     * findAllByEmigrationEquation :
     * Retourne les éléments ayant comme valeur pour l'attribut emigrationEquation le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByEmigrationEquation(Equation v) throws TopiaException {
        List<E> result = findAllByProperty("emigrationEquation", v);
        return result;
    }

    /**
     * findByImmigrationEquation :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut immigrationEquation le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByImmigrationEquation(Equation v) throws TopiaException {
        E result = findByProperty("immigrationEquation", v);
        return result;
    }

    /**
     * findAllByImmigrationEquation :
     * Retourne les éléments ayant comme valeur pour l'attribut immigrationEquation le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByImmigrationEquation(Equation v) throws TopiaException {
        List<E> result = findAllByProperty("immigrationEquation", v);
        return result;
    }

    /**
     * findByPopulation :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut population le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByPopulation(Population v) throws TopiaException {
        E result = findByProperty("population", v);
        return result;
    }

    /**
     * findAllByPopulation :
     * Retourne les éléments ayant comme valeur pour l'attribut population le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByPopulation(Population v) throws TopiaException {
        List<E> result = findAllByProperty("population", v);
        return result;
    }


} //PopulationSeasonInfoDAOAbstract<E extends PopulationSeasonInfo>
