package fr.ifremer.isisfish.entities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class PopulationSeasonInfoAbstract extends SeasonImpl implements PopulationSeasonInfo {

    /**
     * <p>Matrice repr&eacute;sentant la distribution de la reproduction sur les diff&eacute;rents mois de la saison.</p>

     */
    private MatrixND reproductionDistribution;
    /**
     * <p>Si vrai alors la population change de groupe d'age ou de longueurs en debut de saison</p>


     */
    private boolean groupChange;
    /**
     * <p>Indique si la matrice de changementde longeur est une matrice simple ou complexe</p>


     */
    private boolean simpleLengthChangeMatrix;
    /**
     * <p>La matrice de changement de longueur. Appliquable que si la MetaPopulation est en longueur. Cette matrice est [group x group] ou [ (group, zone) x ( group, zone)]</p>
<p></p>

     */
    private MatrixND lengthChangeMatrix;
    /**
     * <p>Indique s'il y a de la reproduction durant la saison</p>


     */
    private boolean reproduction;
    private boolean useEquationMigration;
    /**
     * <p>Matrix [group x zone(left) x zone(reached)]</p>

     */
    private MatrixND migrationMatrix;
    /**
     * <p>Matrix [group x zone(left)]</p>

     */
    private MatrixND emigrationMatrix;
    /**
     * <p>Matrix [group x zone(reached)]</p>

     */
    private MatrixND immigrationMatrix;
    private Equation migrationEquation;
    private Equation emigrationEquation;
    private Equation immigrationEquation;
    public Population population;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(PopulationSeasonInfo.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(PopulationSeasonInfo.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "reproductionDistribution", MatrixND.class, reproductionDistribution);
        visitor.visit(this, "groupChange", boolean.class, groupChange);
        visitor.visit(this, "simpleLengthChangeMatrix", boolean.class, simpleLengthChangeMatrix);
        visitor.visit(this, "lengthChangeMatrix", MatrixND.class, lengthChangeMatrix);
        visitor.visit(this, "reproduction", boolean.class, reproduction);
        visitor.visit(this, "useEquationMigration", boolean.class, useEquationMigration);
        visitor.visit(this, "migrationMatrix", MatrixND.class, migrationMatrix);
        visitor.visit(this, "emigrationMatrix", MatrixND.class, emigrationMatrix);
        visitor.visit(this, "immigrationMatrix", MatrixND.class, immigrationMatrix);
        visitor.visit(this, "migrationEquation", Equation.class, migrationEquation);
        visitor.visit(this, "emigrationEquation", Equation.class, emigrationEquation);
        visitor.visit(this, "immigrationEquation", Equation.class, immigrationEquation);
        visitor.visit(this, "population", Population.class, population);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        tmp.add(getMigrationEquation());
        tmp.add(getEmigrationEquation());
        tmp.add(getImmigrationEquation());

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setReproductionDistribution :
     * @param value 
     */

    public void setReproductionDistribution(MatrixND value) {
        MatrixND _oldValue = this.reproductionDistribution;
        fireOnPreWrite("reproductionDistribution", _oldValue, value);
        this.reproductionDistribution = value;
        fireOnPostWrite("reproductionDistribution", _oldValue, value);
}

    /**
     * getReproductionDistribution :
     * @return MatrixND 
     */

    public MatrixND getReproductionDistribution() {
        fireOnPreRead("reproductionDistribution", reproductionDistribution);
        MatrixND result = this.reproductionDistribution;
        fireOnPostRead("reproductionDistribution", reproductionDistribution);
        return result;
}

    /**
     * setGroupChange :
     * @param value 
     */

    public void setGroupChange(boolean value) {
        boolean _oldValue = this.groupChange;
        fireOnPreWrite("groupChange", _oldValue, value);
        this.groupChange = value;
        fireOnPostWrite("groupChange", _oldValue, value);
}

    /**
     * getGroupChange :
     * @return boolean 
     */

    public boolean getGroupChange() {
        fireOnPreRead("groupChange", groupChange);
        boolean result = this.groupChange;
        fireOnPostRead("groupChange", groupChange);
        return result;
}

    /**
     * setSimpleLengthChangeMatrix :
     * @param value 
     */

    public void setSimpleLengthChangeMatrix(boolean value) {
        boolean _oldValue = this.simpleLengthChangeMatrix;
        fireOnPreWrite("simpleLengthChangeMatrix", _oldValue, value);
        this.simpleLengthChangeMatrix = value;
        fireOnPostWrite("simpleLengthChangeMatrix", _oldValue, value);
}

    /**
     * getSimpleLengthChangeMatrix :
     * @return boolean 
     */

    public boolean getSimpleLengthChangeMatrix() {
        fireOnPreRead("simpleLengthChangeMatrix", simpleLengthChangeMatrix);
        boolean result = this.simpleLengthChangeMatrix;
        fireOnPostRead("simpleLengthChangeMatrix", simpleLengthChangeMatrix);
        return result;
}

    /**
     * setLengthChangeMatrix :
     * @param value 
     */

    public void setLengthChangeMatrix(MatrixND value) {
        MatrixND _oldValue = this.lengthChangeMatrix;
        fireOnPreWrite("lengthChangeMatrix", _oldValue, value);
        this.lengthChangeMatrix = value;
        fireOnPostWrite("lengthChangeMatrix", _oldValue, value);
}

    /**
     * getLengthChangeMatrix :
     * @return MatrixND 
     */

    public MatrixND getLengthChangeMatrix() {
        fireOnPreRead("lengthChangeMatrix", lengthChangeMatrix);
        MatrixND result = this.lengthChangeMatrix;
        fireOnPostRead("lengthChangeMatrix", lengthChangeMatrix);
        return result;
}

    /**
     * setReproduction :
     * @param value 
     */

    public void setReproduction(boolean value) {
        boolean _oldValue = this.reproduction;
        fireOnPreWrite("reproduction", _oldValue, value);
        this.reproduction = value;
        fireOnPostWrite("reproduction", _oldValue, value);
}

    /**
     * getReproduction :
     * @return boolean 
     */

    public boolean getReproduction() {
        fireOnPreRead("reproduction", reproduction);
        boolean result = this.reproduction;
        fireOnPostRead("reproduction", reproduction);
        return result;
}

    /**
     * setUseEquationMigration :
     * @param value 
     */

    public void setUseEquationMigration(boolean value) {
        boolean _oldValue = this.useEquationMigration;
        fireOnPreWrite("useEquationMigration", _oldValue, value);
        this.useEquationMigration = value;
        fireOnPostWrite("useEquationMigration", _oldValue, value);
}

    /**
     * getUseEquationMigration :
     * @return boolean 
     */

    public boolean getUseEquationMigration() {
        fireOnPreRead("useEquationMigration", useEquationMigration);
        boolean result = this.useEquationMigration;
        fireOnPostRead("useEquationMigration", useEquationMigration);
        return result;
}

    /**
     * setMigrationMatrix :
     * @param value 
     */

    public void setMigrationMatrix(MatrixND value) {
        MatrixND _oldValue = this.migrationMatrix;
        fireOnPreWrite("migrationMatrix", _oldValue, value);
        this.migrationMatrix = value;
        fireOnPostWrite("migrationMatrix", _oldValue, value);
}

    /**
     * getMigrationMatrix :
     * @return MatrixND 
     */

    public MatrixND getMigrationMatrix() {
        fireOnPreRead("migrationMatrix", migrationMatrix);
        MatrixND result = this.migrationMatrix;
        fireOnPostRead("migrationMatrix", migrationMatrix);
        return result;
}

    /**
     * setEmigrationMatrix :
     * @param value 
     */

    public void setEmigrationMatrix(MatrixND value) {
        MatrixND _oldValue = this.emigrationMatrix;
        fireOnPreWrite("emigrationMatrix", _oldValue, value);
        this.emigrationMatrix = value;
        fireOnPostWrite("emigrationMatrix", _oldValue, value);
}

    /**
     * getEmigrationMatrix :
     * @return MatrixND 
     */

    public MatrixND getEmigrationMatrix() {
        fireOnPreRead("emigrationMatrix", emigrationMatrix);
        MatrixND result = this.emigrationMatrix;
        fireOnPostRead("emigrationMatrix", emigrationMatrix);
        return result;
}

    /**
     * setImmigrationMatrix :
     * @param value 
     */

    public void setImmigrationMatrix(MatrixND value) {
        MatrixND _oldValue = this.immigrationMatrix;
        fireOnPreWrite("immigrationMatrix", _oldValue, value);
        this.immigrationMatrix = value;
        fireOnPostWrite("immigrationMatrix", _oldValue, value);
}

    /**
     * getImmigrationMatrix :
     * @return MatrixND 
     */

    public MatrixND getImmigrationMatrix() {
        fireOnPreRead("immigrationMatrix", immigrationMatrix);
        MatrixND result = this.immigrationMatrix;
        fireOnPostRead("immigrationMatrix", immigrationMatrix);
        return result;
}

    /**
     * setMigrationEquation :
     * @param value 
     */

    public void setMigrationEquation(Equation value) {
        Equation _oldValue = this.migrationEquation;
        fireOnPreWrite("migrationEquation", _oldValue, value);
        this.migrationEquation = value;
        fireOnPostWrite("migrationEquation", _oldValue, value);
}

    /**
     * getMigrationEquation :
     * @return Equation 
     */

    public Equation getMigrationEquation() {
        fireOnPreRead("migrationEquation", migrationEquation);
        Equation result = this.migrationEquation;
        fireOnPostRead("migrationEquation", migrationEquation);
        return result;
}

    /**
     * setEmigrationEquation :
     * @param value 
     */

    public void setEmigrationEquation(Equation value) {
        Equation _oldValue = this.emigrationEquation;
        fireOnPreWrite("emigrationEquation", _oldValue, value);
        this.emigrationEquation = value;
        fireOnPostWrite("emigrationEquation", _oldValue, value);
}

    /**
     * getEmigrationEquation :
     * @return Equation 
     */

    public Equation getEmigrationEquation() {
        fireOnPreRead("emigrationEquation", emigrationEquation);
        Equation result = this.emigrationEquation;
        fireOnPostRead("emigrationEquation", emigrationEquation);
        return result;
}

    /**
     * setImmigrationEquation :
     * @param value 
     */

    public void setImmigrationEquation(Equation value) {
        Equation _oldValue = this.immigrationEquation;
        fireOnPreWrite("immigrationEquation", _oldValue, value);
        this.immigrationEquation = value;
        fireOnPostWrite("immigrationEquation", _oldValue, value);
}

    /**
     * getImmigrationEquation :
     * @return Equation 
     */

    public Equation getImmigrationEquation() {
        fireOnPreRead("immigrationEquation", immigrationEquation);
        Equation result = this.immigrationEquation;
        fireOnPostRead("immigrationEquation", immigrationEquation);
        return result;
}

    /**
     * setPopulation :
     * @param value 
     */

    public void setPopulation(Population value) {
        Population _oldValue = this.population;
        fireOnPreWrite("population", _oldValue, value);
        this.population = value;
        fireOnPostWrite("population", _oldValue, value);
}

    /**
     * getPopulation :
     * @return Population 
     */

    public Population getPopulation() {
        fireOnPreRead("population", population);
        Population result = this.population;
        fireOnPostRead("population", population);
        return result;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("reproductionDistribution", this.reproductionDistribution).
            append("groupChange", this.groupChange).
            append("simpleLengthChangeMatrix", this.simpleLengthChangeMatrix).
            append("lengthChangeMatrix", this.lengthChangeMatrix).
            append("reproduction", this.reproduction).
            append("useEquationMigration", this.useEquationMigration).
            append("migrationMatrix", this.migrationMatrix).
            append("emigrationMatrix", this.emigrationMatrix).
            append("immigrationMatrix", this.immigrationMatrix).
            append("migrationEquation", this.migrationEquation).
            append("emigrationEquation", this.emigrationEquation).
            append("immigrationEquation", this.immigrationEquation).
         toString();
        return result;
}


} //PopulationSeasonInfoAbstract
