package fr.ifremer.isisfish.entities;

import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class PopulationGroupDAOAbstract<E extends PopulationGroup> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)PopulationGroup.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
                {
                List<fr.ifremer.isisfish.entities.Population> list = getContext()
                            .getDAO(fr.ifremer.isisfish.entities.Population.class)
                            .findAllByProperties("maturityGroup", entity);
                    for (fr.ifremer.isisfish.entities.Population item : list) {
                        item.setMaturityGroup(null);

                    }
                }

        super.delete(entity);
    }

    /**
     * findById :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut id le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findById(int v) throws TopiaException {
        E result = findByProperty("id", v);
        return result;
    }

    /**
     * findAllById :
     * Retourne les éléments ayant comme valeur pour l'attribut id le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllById(int v) throws TopiaException {
        List<E> result = findAllByProperty("id", v);
        return result;
    }

    /**
     * findByReproductionRate :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut reproductionRate le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByReproductionRate(double v) throws TopiaException {
        E result = findByProperty("reproductionRate", v);
        return result;
    }

    /**
     * findAllByReproductionRate :
     * Retourne les éléments ayant comme valeur pour l'attribut reproductionRate le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByReproductionRate(double v) throws TopiaException {
        List<E> result = findAllByProperty("reproductionRate", v);
        return result;
    }

    /**
     * findByAge :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut age le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByAge(double v) throws TopiaException {
        E result = findByProperty("age", v);
        return result;
    }

    /**
     * findAllByAge :
     * Retourne les éléments ayant comme valeur pour l'attribut age le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByAge(double v) throws TopiaException {
        List<E> result = findAllByProperty("age", v);
        return result;
    }

    /**
     * findByMinLength :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut minLength le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMinLength(double v) throws TopiaException {
        E result = findByProperty("minLength", v);
        return result;
    }

    /**
     * findAllByMinLength :
     * Retourne les éléments ayant comme valeur pour l'attribut minLength le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMinLength(double v) throws TopiaException {
        List<E> result = findAllByProperty("minLength", v);
        return result;
    }

    /**
     * findByMaxLength :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut maxLength le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMaxLength(double v) throws TopiaException {
        E result = findByProperty("maxLength", v);
        return result;
    }

    /**
     * findAllByMaxLength :
     * Retourne les éléments ayant comme valeur pour l'attribut maxLength le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMaxLength(double v) throws TopiaException {
        List<E> result = findAllByProperty("maxLength", v);
        return result;
    }

    /**
     * findByComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty("comment", v);
        return result;
    }

    /**
     * findAllByComment :
     * Retourne les éléments ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty("comment", v);
        return result;
    }

    /**
     * findByPopulation :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut population le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByPopulation(Population v) throws TopiaException {
        E result = findByProperty("population", v);
        return result;
    }

    /**
     * findAllByPopulation :
     * Retourne les éléments ayant comme valeur pour l'attribut population le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByPopulation(Population v) throws TopiaException {
        List<E> result = findAllByProperty("population", v);
        return result;
    }


} //PopulationGroupDAOAbstract<E extends PopulationGroup>
