package fr.ifremer.isisfish.entities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class PopulationGroupAbstract extends TopiaEntityAbstract implements PopulationGroup {

    private int id;
    /**
     * <p>Le taux de f&eacute;condit&eacute; pour le group</p>


     */
    private double reproductionRate;
    private double age;
    private double minLength;
    private double maxLength;
    private String comment;
    public Population population;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(PopulationGroup.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(PopulationGroup.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "id", int.class, id);
        visitor.visit(this, "reproductionRate", double.class, reproductionRate);
        visitor.visit(this, "age", double.class, age);
        visitor.visit(this, "minLength", double.class, minLength);
        visitor.visit(this, "maxLength", double.class, maxLength);
        visitor.visit(this, "comment", String.class, comment);
        visitor.visit(this, "population", Population.class, population);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setId :
     * @param value 
     */

    public void setId(int value) {
        int _oldValue = this.id;
        fireOnPreWrite("id", _oldValue, value);
        this.id = value;
        fireOnPostWrite("id", _oldValue, value);
}

    /**
     * getId :
     * @return int 
     */

    public int getId() {
        fireOnPreRead("id", id);
        int result = this.id;
        fireOnPostRead("id", id);
        return result;
}

    /**
     * setReproductionRate :
     * @param value 
     */

    public void setReproductionRate(double value) {
        double _oldValue = this.reproductionRate;
        fireOnPreWrite("reproductionRate", _oldValue, value);
        this.reproductionRate = value;
        fireOnPostWrite("reproductionRate", _oldValue, value);
}

    /**
     * getReproductionRate :
     * @return double 
     */

    public double getReproductionRate() {
        fireOnPreRead("reproductionRate", reproductionRate);
        double result = this.reproductionRate;
        fireOnPostRead("reproductionRate", reproductionRate);
        return result;
}

    /**
     * setAge :
     * @param value 
     */

    public void setAge(double value) {
        double _oldValue = this.age;
        fireOnPreWrite("age", _oldValue, value);
        this.age = value;
        fireOnPostWrite("age", _oldValue, value);
}

    /**
     * getAge :
     * @return double 
     */

    public double getAge() {
        fireOnPreRead("age", age);
        double result = this.age;
        fireOnPostRead("age", age);
        return result;
}

    /**
     * setMinLength :
     * @param value 
     */

    public void setMinLength(double value) {
        double _oldValue = this.minLength;
        fireOnPreWrite("minLength", _oldValue, value);
        this.minLength = value;
        fireOnPostWrite("minLength", _oldValue, value);
}

    /**
     * getMinLength :
     * @return double 
     */

    public double getMinLength() {
        fireOnPreRead("minLength", minLength);
        double result = this.minLength;
        fireOnPostRead("minLength", minLength);
        return result;
}

    /**
     * setMaxLength :
     * @param value 
     */

    public void setMaxLength(double value) {
        double _oldValue = this.maxLength;
        fireOnPreWrite("maxLength", _oldValue, value);
        this.maxLength = value;
        fireOnPostWrite("maxLength", _oldValue, value);
}

    /**
     * getMaxLength :
     * @return double 
     */

    public double getMaxLength() {
        fireOnPreRead("maxLength", maxLength);
        double result = this.maxLength;
        fireOnPostRead("maxLength", maxLength);
        return result;
}

    /**
     * setComment :
     * @param value 
     */

    public void setComment(String value) {
        String _oldValue = this.comment;
        fireOnPreWrite("comment", _oldValue, value);
        this.comment = value;
        fireOnPostWrite("comment", _oldValue, value);
}

    /**
     * getComment :
     * @return String 
     */

    public String getComment() {
        fireOnPreRead("comment", comment);
        String result = this.comment;
        fireOnPostRead("comment", comment);
        return result;
}

    /**
     * setPopulation :
     * @param value 
     */

    public void setPopulation(Population value) {
        Population _oldValue = this.population;
        fireOnPreWrite("population", _oldValue, value);
        this.population = value;
        fireOnPostWrite("population", _oldValue, value);
}

    /**
     * getPopulation :
     * @return Population 
     */

    public Population getPopulation() {
        fireOnPreRead("population", population);
        Population result = this.population;
        fireOnPostRead("population", population);
        return result;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("id", this.id).
            append("reproductionRate", this.reproductionRate).
            append("age", this.age).
            append("minLength", this.minLength).
            append("maxLength", this.maxLength).
            append("comment", this.comment).
         toString();
        return result;
}


} //PopulationGroupAbstract
