package fr.ifremer.isisfish.entities;

import java.util.Arrays;
import java.util.List;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class PopulationDAOAbstract<E extends Population> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Population.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
                {
                List<fr.ifremer.isisfish.entities.PopulationSeasonInfo> list = getContext()
                            .getDAO(fr.ifremer.isisfish.entities.PopulationSeasonInfo.class)
                            .findAllByProperties("population", entity);
                    for (fr.ifremer.isisfish.entities.PopulationSeasonInfo item : list) {
                        item.setPopulation(null);

                    }
                }

        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty("name", v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty("name", v);
        return result;
    }

    /**
     * findByGeographicId :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut geographicId le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByGeographicId(String v) throws TopiaException {
        E result = findByProperty("geographicId", v);
        return result;
    }

    /**
     * findAllByGeographicId :
     * Retourne les éléments ayant comme valeur pour l'attribut geographicId le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByGeographicId(String v) throws TopiaException {
        List<E> result = findAllByProperty("geographicId", v);
        return result;
    }

    /**
     * findByPlusGroup :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut plusGroup le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByPlusGroup(boolean v) throws TopiaException {
        E result = findByProperty("plusGroup", v);
        return result;
    }

    /**
     * findAllByPlusGroup :
     * Retourne les éléments ayant comme valeur pour l'attribut plusGroup le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByPlusGroup(boolean v) throws TopiaException {
        List<E> result = findAllByProperty("plusGroup", v);
        return result;
    }

    /**
     * findByGrowth :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut growth le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByGrowth(Equation v) throws TopiaException {
        E result = findByProperty("growth", v);
        return result;
    }

    /**
     * findAllByGrowth :
     * Retourne les éléments ayant comme valeur pour l'attribut growth le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByGrowth(Equation v) throws TopiaException {
        List<E> result = findAllByProperty("growth", v);
        return result;
    }

    /**
     * findByGrowthReverse :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut growthReverse le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByGrowthReverse(Equation v) throws TopiaException {
        E result = findByProperty("growthReverse", v);
        return result;
    }

    /**
     * findAllByGrowthReverse :
     * Retourne les éléments ayant comme valeur pour l'attribut growthReverse le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByGrowthReverse(Equation v) throws TopiaException {
        List<E> result = findAllByProperty("growthReverse", v);
        return result;
    }

    /**
     * findByComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty("comment", v);
        return result;
    }

    /**
     * findAllByComment :
     * Retourne les éléments ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty("comment", v);
        return result;
    }

    /**
     * findByMeanWeight :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut meanWeight le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMeanWeight(Equation v) throws TopiaException {
        E result = findByProperty("meanWeight", v);
        return result;
    }

    /**
     * findAllByMeanWeight :
     * Retourne les éléments ayant comme valeur pour l'attribut meanWeight le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMeanWeight(Equation v) throws TopiaException {
        List<E> result = findAllByProperty("meanWeight", v);
        return result;
    }

    /**
     * findByPrice :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut price le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByPrice(Equation v) throws TopiaException {
        E result = findByProperty("price", v);
        return result;
    }

    /**
     * findAllByPrice :
     * Retourne les éléments ayant comme valeur pour l'attribut price le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByPrice(Equation v) throws TopiaException {
        List<E> result = findAllByProperty("price", v);
        return result;
    }

    /**
     * findByNaturalDeathRate :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut naturalDeathRate le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByNaturalDeathRate(Equation v) throws TopiaException {
        E result = findByProperty("naturalDeathRate", v);
        return result;
    }

    /**
     * findAllByNaturalDeathRate :
     * Retourne les éléments ayant comme valeur pour l'attribut naturalDeathRate le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByNaturalDeathRate(Equation v) throws TopiaException {
        List<E> result = findAllByProperty("naturalDeathRate", v);
        return result;
    }

    /**
     * findByCaractBioComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut caractBioComment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCaractBioComment(String v) throws TopiaException {
        E result = findByProperty("caractBioComment", v);
        return result;
    }

    /**
     * findAllByCaractBioComment :
     * Retourne les éléments ayant comme valeur pour l'attribut caractBioComment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCaractBioComment(String v) throws TopiaException {
        List<E> result = findAllByProperty("caractBioComment", v);
        return result;
    }

    /**
     * findByReproductionEquation :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut reproductionEquation le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByReproductionEquation(Equation v) throws TopiaException {
        E result = findByProperty("reproductionEquation", v);
        return result;
    }

    /**
     * findAllByReproductionEquation :
     * Retourne les éléments ayant comme valeur pour l'attribut reproductionEquation le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByReproductionEquation(Equation v) throws TopiaException {
        List<E> result = findAllByProperty("reproductionEquation", v);
        return result;
    }

    /**
     * findByMonthGapBetweenReproRecrutement :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut monthGapBetweenReproRecrutement le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMonthGapBetweenReproRecrutement(int v) throws TopiaException {
        E result = findByProperty("monthGapBetweenReproRecrutement", v);
        return result;
    }

    /**
     * findAllByMonthGapBetweenReproRecrutement :
     * Retourne les éléments ayant comme valeur pour l'attribut monthGapBetweenReproRecrutement le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMonthGapBetweenReproRecrutement(int v) throws TopiaException {
        List<E> result = findAllByProperty("monthGapBetweenReproRecrutement", v);
        return result;
    }

    /**
     * findByRecruitmentDistribution :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut recruitmentDistribution le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByRecruitmentDistribution(MatrixND v) throws TopiaException {
        E result = findByProperty("recruitmentDistribution", v);
        return result;
    }

    /**
     * findAllByRecruitmentDistribution :
     * Retourne les éléments ayant comme valeur pour l'attribut recruitmentDistribution le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByRecruitmentDistribution(MatrixND v) throws TopiaException {
        List<E> result = findAllByProperty("recruitmentDistribution", v);
        return result;
    }

    /**
     * findByRecruitmentComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut recruitmentComment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByRecruitmentComment(String v) throws TopiaException {
        E result = findByProperty("recruitmentComment", v);
        return result;
    }

    /**
     * findAllByRecruitmentComment :
     * Retourne les éléments ayant comme valeur pour l'attribut recruitmentComment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByRecruitmentComment(String v) throws TopiaException {
        List<E> result = findAllByProperty("recruitmentComment", v);
        return result;
    }

    /**
     * findByZonesComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut zonesComment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByZonesComment(String v) throws TopiaException {
        E result = findByProperty("zonesComment", v);
        return result;
    }

    /**
     * findAllByZonesComment :
     * Retourne les éléments ayant comme valeur pour l'attribut zonesComment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByZonesComment(String v) throws TopiaException {
        List<E> result = findAllByProperty("zonesComment", v);
        return result;
    }

    /**
     * findBySeasonsComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut seasonsComment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findBySeasonsComment(String v) throws TopiaException {
        E result = findByProperty("seasonsComment", v);
        return result;
    }

    /**
     * findAllBySeasonsComment :
     * Retourne les éléments ayant comme valeur pour l'attribut seasonsComment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllBySeasonsComment(String v) throws TopiaException {
        List<E> result = findAllByProperty("seasonsComment", v);
        return result;
    }

    /**
     * findByCapturabilityComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut capturabilityComment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCapturabilityComment(String v) throws TopiaException {
        E result = findByProperty("capturabilityComment", v);
        return result;
    }

    /**
     * findAllByCapturabilityComment :
     * Retourne les éléments ayant comme valeur pour l'attribut capturabilityComment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCapturabilityComment(String v) throws TopiaException {
        List<E> result = findAllByProperty("capturabilityComment", v);
        return result;
    }

    /**
     * findByMigrationComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut migrationComment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMigrationComment(String v) throws TopiaException {
        E result = findByProperty("migrationComment", v);
        return result;
    }

    /**
     * findAllByMigrationComment :
     * Retourne les éléments ayant comme valeur pour l'attribut migrationComment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMigrationComment(String v) throws TopiaException {
        List<E> result = findAllByProperty("migrationComment", v);
        return result;
    }

    /**
     * findByMappingZoneReproZoneRecru :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut mappingZoneReproZoneRecru le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMappingZoneReproZoneRecru(MatrixND v) throws TopiaException {
        E result = findByProperty("mappingZoneReproZoneRecru", v);
        return result;
    }

    /**
     * findAllByMappingZoneReproZoneRecru :
     * Retourne les éléments ayant comme valeur pour l'attribut mappingZoneReproZoneRecru le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMappingZoneReproZoneRecru(MatrixND v) throws TopiaException {
        List<E> result = findAllByProperty("mappingZoneReproZoneRecru", v);
        return result;
    }

    /**
     * findByCapturability :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut capturability le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCapturability(MatrixND v) throws TopiaException {
        E result = findByProperty("capturability", v);
        return result;
    }

    /**
     * findAllByCapturability :
     * Retourne les éléments ayant comme valeur pour l'attribut capturability le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCapturability(MatrixND v) throws TopiaException {
        List<E> result = findAllByProperty("capturability", v);
        return result;
    }

    /**
     * findContainsPopulationGroup :
     * Retourne le premier élément trouvé dont l'attribut populationGroup contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsPopulationGroup(PopulationGroup... v) throws TopiaException {
        E result = findContainsProperties("populationGroup", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsPopulationGroup :
     * Retourne les éléments trouvé dont l'attribut populationGroup contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsPopulationGroup(PopulationGroup... v) throws TopiaException {
        List<E> results = findAllContainsProperties("populationGroup", Arrays.asList(v));
        return results;
    }

    /**
     * findContainsPopulationSeasonInfo :
     * Retourne le premier élément trouvé dont l'attribut populationSeasonInfo contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsPopulationSeasonInfo(PopulationSeasonInfo... v) throws TopiaException {
        E result = findContainsProperties("populationSeasonInfo", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsPopulationSeasonInfo :
     * Retourne les éléments trouvé dont l'attribut populationSeasonInfo contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsPopulationSeasonInfo(PopulationSeasonInfo... v) throws TopiaException {
        List<E> results = findAllContainsProperties("populationSeasonInfo", Arrays.asList(v));
        return results;
    }

    /**
     * findBySpecies :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut species le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findBySpecies(Species v) throws TopiaException {
        E result = findByProperty("species", v);
        return result;
    }

    /**
     * findAllBySpecies :
     * Retourne les éléments ayant comme valeur pour l'attribut species le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllBySpecies(Species v) throws TopiaException {
        List<E> result = findAllByProperty("species", v);
        return result;
    }

    /**
     * findContainsReproductionZone :
     * Retourne le premier élément trouvé dont l'attribut reproductionZone contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsReproductionZone(Zone... v) throws TopiaException {
        E result = findContainsProperties("reproductionZone", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsReproductionZone :
     * Retourne les éléments trouvé dont l'attribut reproductionZone contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsReproductionZone(Zone... v) throws TopiaException {
        List<E> results = findAllContainsProperties("reproductionZone", Arrays.asList(v));
        return results;
    }

    /**
     * findContainsPopulationZone :
     * Retourne le premier élément trouvé dont l'attribut populationZone contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsPopulationZone(Zone... v) throws TopiaException {
        E result = findContainsProperties("populationZone", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsPopulationZone :
     * Retourne les éléments trouvé dont l'attribut populationZone contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsPopulationZone(Zone... v) throws TopiaException {
        List<E> results = findAllContainsProperties("populationZone", Arrays.asList(v));
        return results;
    }

    /**
     * findContainsRecruitmentZone :
     * Retourne le premier élément trouvé dont l'attribut recruitmentZone contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsRecruitmentZone(Zone... v) throws TopiaException {
        E result = findContainsProperties("recruitmentZone", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsRecruitmentZone :
     * Retourne les éléments trouvé dont l'attribut recruitmentZone contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsRecruitmentZone(Zone... v) throws TopiaException {
        List<E> results = findAllContainsProperties("recruitmentZone", Arrays.asList(v));
        return results;
    }

    /**
     * findByMaturityGroup :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut maturityGroup le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMaturityGroup(PopulationGroup v) throws TopiaException {
        E result = findByProperty("maturityGroup", v);
        return result;
    }

    /**
     * findAllByMaturityGroup :
     * Retourne les éléments ayant comme valeur pour l'attribut maturityGroup le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMaturityGroup(PopulationGroup v) throws TopiaException {
        List<E> result = findAllByProperty("maturityGroup", v);
        return result;
    }


} //PopulationDAOAbstract<E extends Population>
