package fr.ifremer.isisfish.entities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class PopulationAbstract extends TopiaEntityAbstract implements Population {

    private String name;
    private String geographicId;
    private boolean plusGroup;
    private Equation growth;
    private Equation growthReverse;
    private String comment;
    private Equation meanWeight;
    /**
     * <p>Le prix en Kg</p>


     */
    private Equation price;
    private Equation naturalDeathRate;
    private String caractBioComment;
    private Equation reproductionEquation;
    private int monthGapBetweenReproRecrutement;
    private MatrixND recruitmentDistribution;
    private String recruitmentComment;
    private String zonesComment;
    private String seasonsComment;
    private String capturabilityComment;
    private String migrationComment;
    private MatrixND mappingZoneReproZoneRecru;
    private MatrixND capturability;
    public Collection<Selectivity> gearSelectivity;
    public List<PopulationGroup> populationGroup;
    public List<PopulationSeasonInfo> populationSeasonInfo;
    public Species species;
    public List<Zone> reproductionZone;
    public List<Zone> populationZone;
    public List<Zone> recruitmentZone;
    public PopulationGroup maturityGroup;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Population.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Population.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "name", String.class, name);
        visitor.visit(this, "geographicId", String.class, geographicId);
        visitor.visit(this, "plusGroup", boolean.class, plusGroup);
        visitor.visit(this, "growth", Equation.class, growth);
        visitor.visit(this, "growthReverse", Equation.class, growthReverse);
        visitor.visit(this, "comment", String.class, comment);
        visitor.visit(this, "meanWeight", Equation.class, meanWeight);
        visitor.visit(this, "price", Equation.class, price);
        visitor.visit(this, "naturalDeathRate", Equation.class, naturalDeathRate);
        visitor.visit(this, "caractBioComment", String.class, caractBioComment);
        visitor.visit(this, "reproductionEquation", Equation.class, reproductionEquation);
        visitor.visit(this, "monthGapBetweenReproRecrutement", int.class, monthGapBetweenReproRecrutement);
        visitor.visit(this, "recruitmentDistribution", MatrixND.class, recruitmentDistribution);
        visitor.visit(this, "recruitmentComment", String.class, recruitmentComment);
        visitor.visit(this, "zonesComment", String.class, zonesComment);
        visitor.visit(this, "seasonsComment", String.class, seasonsComment);
        visitor.visit(this, "capturabilityComment", String.class, capturabilityComment);
        visitor.visit(this, "migrationComment", String.class, migrationComment);
        visitor.visit(this, "mappingZoneReproZoneRecru", MatrixND.class, mappingZoneReproZoneRecru);
        visitor.visit(this, "capturability", MatrixND.class, capturability);
        visitor.visit(this, "gearSelectivity", java.util.Collection.class, Selectivity.class, gearSelectivity);
        visitor.visit(this, "populationGroup", List.class, PopulationGroup.class, populationGroup);
        visitor.visit(this, "populationSeasonInfo", List.class, PopulationSeasonInfo.class, populationSeasonInfo);
        visitor.visit(this, "species", Species.class, species);
        visitor.visit(this, "reproductionZone", List.class, Zone.class, reproductionZone);
        visitor.visit(this, "populationZone", List.class, Zone.class, populationZone);
        visitor.visit(this, "recruitmentZone", List.class, Zone.class, recruitmentZone);
        visitor.visit(this, "maturityGroup", PopulationGroup.class, maturityGroup);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        tmp.add(getGrowth());
        tmp.add(getGrowthReverse());
        tmp.add(getMeanWeight());
        tmp.add(getPrice());
        tmp.add(getNaturalDeathRate());
        tmp.add(getReproductionEquation());

        {
            org.nuiton.topia.persistence.TopiaDAO<Selectivity> dao = ((TopiaContextImplementor) getTopiaContext()).getDAO(Selectivity.class);
            List<Selectivity> findAllByProperties = dao.findAllByProperties("population", this);
            if (findAllByProperties != null) {
                tmp.addAll(findAllByProperties);
            }
        }
        if (getPopulationGroup() != null) {
              tmp.addAll(getPopulationGroup());
           }
        if (getPopulationSeasonInfo() != null) {
              tmp.addAll(getPopulationSeasonInfo());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        fireOnPostWrite("name", _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead("name", name);
        String result = this.name;
        fireOnPostRead("name", name);
        return result;
}

    /**
     * setGeographicId :
     * @param value 
     */

    public void setGeographicId(String value) {
        String _oldValue = this.geographicId;
        fireOnPreWrite("geographicId", _oldValue, value);
        this.geographicId = value;
        fireOnPostWrite("geographicId", _oldValue, value);
}

    /**
     * getGeographicId :
     * @return String 
     */

    public String getGeographicId() {
        fireOnPreRead("geographicId", geographicId);
        String result = this.geographicId;
        fireOnPostRead("geographicId", geographicId);
        return result;
}

    /**
     * setPlusGroup :
     * @param value 
     */

    public void setPlusGroup(boolean value) {
        boolean _oldValue = this.plusGroup;
        fireOnPreWrite("plusGroup", _oldValue, value);
        this.plusGroup = value;
        fireOnPostWrite("plusGroup", _oldValue, value);
}

    /**
     * getPlusGroup :
     * @return boolean 
     */

    public boolean getPlusGroup() {
        fireOnPreRead("plusGroup", plusGroup);
        boolean result = this.plusGroup;
        fireOnPostRead("plusGroup", plusGroup);
        return result;
}

    /**
     * setGrowth :
     * @param value 
     */

    public void setGrowth(Equation value) {
        Equation _oldValue = this.growth;
        fireOnPreWrite("growth", _oldValue, value);
        this.growth = value;
        fireOnPostWrite("growth", _oldValue, value);
}

    /**
     * getGrowth :
     * @return Equation 
     */

    public Equation getGrowth() {
        fireOnPreRead("growth", growth);
        Equation result = this.growth;
        fireOnPostRead("growth", growth);
        return result;
}

    /**
     * setGrowthReverse :
     * @param value 
     */

    public void setGrowthReverse(Equation value) {
        Equation _oldValue = this.growthReverse;
        fireOnPreWrite("growthReverse", _oldValue, value);
        this.growthReverse = value;
        fireOnPostWrite("growthReverse", _oldValue, value);
}

    /**
     * getGrowthReverse :
     * @return Equation 
     */

    public Equation getGrowthReverse() {
        fireOnPreRead("growthReverse", growthReverse);
        Equation result = this.growthReverse;
        fireOnPostRead("growthReverse", growthReverse);
        return result;
}

    /**
     * setComment :
     * @param value 
     */

    public void setComment(String value) {
        String _oldValue = this.comment;
        fireOnPreWrite("comment", _oldValue, value);
        this.comment = value;
        fireOnPostWrite("comment", _oldValue, value);
}

    /**
     * getComment :
     * @return String 
     */

    public String getComment() {
        fireOnPreRead("comment", comment);
        String result = this.comment;
        fireOnPostRead("comment", comment);
        return result;
}

    /**
     * setMeanWeight :
     * @param value 
     */

    public void setMeanWeight(Equation value) {
        Equation _oldValue = this.meanWeight;
        fireOnPreWrite("meanWeight", _oldValue, value);
        this.meanWeight = value;
        fireOnPostWrite("meanWeight", _oldValue, value);
}

    /**
     * getMeanWeight :
     * @return Equation 
     */

    public Equation getMeanWeight() {
        fireOnPreRead("meanWeight", meanWeight);
        Equation result = this.meanWeight;
        fireOnPostRead("meanWeight", meanWeight);
        return result;
}

    /**
     * setPrice :
     * @param value 
     */

    public void setPrice(Equation value) {
        Equation _oldValue = this.price;
        fireOnPreWrite("price", _oldValue, value);
        this.price = value;
        fireOnPostWrite("price", _oldValue, value);
}

    /**
     * getPrice :
     * @return Equation 
     */

    public Equation getPrice() {
        fireOnPreRead("price", price);
        Equation result = this.price;
        fireOnPostRead("price", price);
        return result;
}

    /**
     * setNaturalDeathRate :
     * @param value 
     */

    public void setNaturalDeathRate(Equation value) {
        Equation _oldValue = this.naturalDeathRate;
        fireOnPreWrite("naturalDeathRate", _oldValue, value);
        this.naturalDeathRate = value;
        fireOnPostWrite("naturalDeathRate", _oldValue, value);
}

    /**
     * getNaturalDeathRate :
     * @return Equation 
     */

    public Equation getNaturalDeathRate() {
        fireOnPreRead("naturalDeathRate", naturalDeathRate);
        Equation result = this.naturalDeathRate;
        fireOnPostRead("naturalDeathRate", naturalDeathRate);
        return result;
}

    /**
     * setCaractBioComment :
     * @param value 
     */

    public void setCaractBioComment(String value) {
        String _oldValue = this.caractBioComment;
        fireOnPreWrite("caractBioComment", _oldValue, value);
        this.caractBioComment = value;
        fireOnPostWrite("caractBioComment", _oldValue, value);
}

    /**
     * getCaractBioComment :
     * @return String 
     */

    public String getCaractBioComment() {
        fireOnPreRead("caractBioComment", caractBioComment);
        String result = this.caractBioComment;
        fireOnPostRead("caractBioComment", caractBioComment);
        return result;
}

    /**
     * setReproductionEquation :
     * @param value 
     */

    public void setReproductionEquation(Equation value) {
        Equation _oldValue = this.reproductionEquation;
        fireOnPreWrite("reproductionEquation", _oldValue, value);
        this.reproductionEquation = value;
        fireOnPostWrite("reproductionEquation", _oldValue, value);
}

    /**
     * getReproductionEquation :
     * @return Equation 
     */

    public Equation getReproductionEquation() {
        fireOnPreRead("reproductionEquation", reproductionEquation);
        Equation result = this.reproductionEquation;
        fireOnPostRead("reproductionEquation", reproductionEquation);
        return result;
}

    /**
     * setMonthGapBetweenReproRecrutement :
     * @param value 
     */

    public void setMonthGapBetweenReproRecrutement(int value) {
        int _oldValue = this.monthGapBetweenReproRecrutement;
        fireOnPreWrite("monthGapBetweenReproRecrutement", _oldValue, value);
        this.monthGapBetweenReproRecrutement = value;
        fireOnPostWrite("monthGapBetweenReproRecrutement", _oldValue, value);
}

    /**
     * getMonthGapBetweenReproRecrutement :
     * @return int 
     */

    public int getMonthGapBetweenReproRecrutement() {
        fireOnPreRead("monthGapBetweenReproRecrutement", monthGapBetweenReproRecrutement);
        int result = this.monthGapBetweenReproRecrutement;
        fireOnPostRead("monthGapBetweenReproRecrutement", monthGapBetweenReproRecrutement);
        return result;
}

    /**
     * setRecruitmentDistribution :
     * @param value 
     */

    public void setRecruitmentDistribution(MatrixND value) {
        MatrixND _oldValue = this.recruitmentDistribution;
        fireOnPreWrite("recruitmentDistribution", _oldValue, value);
        this.recruitmentDistribution = value;
        fireOnPostWrite("recruitmentDistribution", _oldValue, value);
}

    /**
     * getRecruitmentDistribution :
     * @return MatrixND 
     */

    public MatrixND getRecruitmentDistribution() {
        fireOnPreRead("recruitmentDistribution", recruitmentDistribution);
        MatrixND result = this.recruitmentDistribution;
        fireOnPostRead("recruitmentDistribution", recruitmentDistribution);
        return result;
}

    /**
     * setRecruitmentComment :
     * @param value 
     */

    public void setRecruitmentComment(String value) {
        String _oldValue = this.recruitmentComment;
        fireOnPreWrite("recruitmentComment", _oldValue, value);
        this.recruitmentComment = value;
        fireOnPostWrite("recruitmentComment", _oldValue, value);
}

    /**
     * getRecruitmentComment :
     * @return String 
     */

    public String getRecruitmentComment() {
        fireOnPreRead("recruitmentComment", recruitmentComment);
        String result = this.recruitmentComment;
        fireOnPostRead("recruitmentComment", recruitmentComment);
        return result;
}

    /**
     * setZonesComment :
     * @param value 
     */

    public void setZonesComment(String value) {
        String _oldValue = this.zonesComment;
        fireOnPreWrite("zonesComment", _oldValue, value);
        this.zonesComment = value;
        fireOnPostWrite("zonesComment", _oldValue, value);
}

    /**
     * getZonesComment :
     * @return String 
     */

    public String getZonesComment() {
        fireOnPreRead("zonesComment", zonesComment);
        String result = this.zonesComment;
        fireOnPostRead("zonesComment", zonesComment);
        return result;
}

    /**
     * setSeasonsComment :
     * @param value 
     */

    public void setSeasonsComment(String value) {
        String _oldValue = this.seasonsComment;
        fireOnPreWrite("seasonsComment", _oldValue, value);
        this.seasonsComment = value;
        fireOnPostWrite("seasonsComment", _oldValue, value);
}

    /**
     * getSeasonsComment :
     * @return String 
     */

    public String getSeasonsComment() {
        fireOnPreRead("seasonsComment", seasonsComment);
        String result = this.seasonsComment;
        fireOnPostRead("seasonsComment", seasonsComment);
        return result;
}

    /**
     * setCapturabilityComment :
     * @param value 
     */

    public void setCapturabilityComment(String value) {
        String _oldValue = this.capturabilityComment;
        fireOnPreWrite("capturabilityComment", _oldValue, value);
        this.capturabilityComment = value;
        fireOnPostWrite("capturabilityComment", _oldValue, value);
}

    /**
     * getCapturabilityComment :
     * @return String 
     */

    public String getCapturabilityComment() {
        fireOnPreRead("capturabilityComment", capturabilityComment);
        String result = this.capturabilityComment;
        fireOnPostRead("capturabilityComment", capturabilityComment);
        return result;
}

    /**
     * setMigrationComment :
     * @param value 
     */

    public void setMigrationComment(String value) {
        String _oldValue = this.migrationComment;
        fireOnPreWrite("migrationComment", _oldValue, value);
        this.migrationComment = value;
        fireOnPostWrite("migrationComment", _oldValue, value);
}

    /**
     * getMigrationComment :
     * @return String 
     */

    public String getMigrationComment() {
        fireOnPreRead("migrationComment", migrationComment);
        String result = this.migrationComment;
        fireOnPostRead("migrationComment", migrationComment);
        return result;
}

    /**
     * setMappingZoneReproZoneRecru :
     * @param value 
     */

    public void setMappingZoneReproZoneRecru(MatrixND value) {
        MatrixND _oldValue = this.mappingZoneReproZoneRecru;
        fireOnPreWrite("mappingZoneReproZoneRecru", _oldValue, value);
        this.mappingZoneReproZoneRecru = value;
        fireOnPostWrite("mappingZoneReproZoneRecru", _oldValue, value);
}

    /**
     * getMappingZoneReproZoneRecru :
     * @return MatrixND 
     */

    public MatrixND getMappingZoneReproZoneRecru() {
        fireOnPreRead("mappingZoneReproZoneRecru", mappingZoneReproZoneRecru);
        MatrixND result = this.mappingZoneReproZoneRecru;
        fireOnPostRead("mappingZoneReproZoneRecru", mappingZoneReproZoneRecru);
        return result;
}

    /**
     * setCapturability :
     * @param value 
     */

    public void setCapturability(MatrixND value) {
        MatrixND _oldValue = this.capturability;
        fireOnPreWrite("capturability", _oldValue, value);
        this.capturability = value;
        fireOnPostWrite("capturability", _oldValue, value);
}

    /**
     * getCapturability :
     * @return MatrixND 
     */

    public MatrixND getCapturability() {
        fireOnPreRead("capturability", capturability);
        MatrixND result = this.capturability;
        fireOnPostRead("capturability", capturability);
        return result;
}

    /**
     * addPopulationGroup :
     * @param populationGroup 
     */

    public void addPopulationGroup(PopulationGroup populationGroup) {    
        fireOnPreWrite("populationGroup", null, populationGroup);
        if (this.populationGroup == null) {
            this.populationGroup = new ArrayList<PopulationGroup>();
        }
        this.populationGroup.add(populationGroup);
        fireOnPostWrite("populationGroup", this.populationGroup.size(), null, populationGroup);
}

    /**
     * addAllPopulationGroup :
     * @param values 
     */

    public void addAllPopulationGroup(List<PopulationGroup> values) {
        if (values == null) {
            return;
        }
        for (PopulationGroup item : values) {
            addPopulationGroup(item);
        }
}

    /**
     * getPopulationGroupByTopiaId :
     * @param topiaId 
     * @return PopulationGroup 
     */

    public PopulationGroup getPopulationGroupByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(populationGroup, topiaId);
 }

    /**
     * setPopulationGroup :
     * @param values 
     */

    public void setPopulationGroup(List<PopulationGroup> values) {
        List<PopulationGroup> _oldValue = populationGroup;
        fireOnPreWrite("populationGroup", _oldValue, values);
        populationGroup = values;
        fireOnPostWrite("populationGroup", _oldValue, values);
}

    /**
     * removePopulationGroup :
     * @param value 
     */

    public void removePopulationGroup(PopulationGroup value) {
        fireOnPreWrite("populationGroup", value, null);
        if ((this.populationGroup == null) || (!this.populationGroup.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        fireOnPostWrite("populationGroup", this.populationGroup.size()+1, value, null);
}

    /**
     * clearPopulationGroup :
     */

    public void clearPopulationGroup() {
        if (this.populationGroup == null) {
            return;
        }
        List<PopulationGroup> _oldValue = new ArrayList<PopulationGroup>(this.populationGroup);
        fireOnPreWrite("populationGroup", _oldValue, this.populationGroup);
        this.populationGroup.clear();
        fireOnPostWrite("populationGroup", _oldValue, this.populationGroup);
}

    /**
     * getPopulationGroup :
     * @return List<PopulationGroup> 
     */

    public List<PopulationGroup> getPopulationGroup() {
        return populationGroup;
}

    /**
     * sizePopulationGroup :
     * @return int 
     */

    public int sizePopulationGroup() {
        if (populationGroup == null) {
            return 0;
        }
        return populationGroup.size();
}

    /**
     * isPopulationGroupEmpty :
     * @return boolean 
     */

    public boolean isPopulationGroupEmpty() {
        int size = sizePopulationGroup();
        return size == 0;
}

    /**
     * addPopulationSeasonInfo :
     * @param populationSeasonInfo 
     */

    public void addPopulationSeasonInfo(PopulationSeasonInfo populationSeasonInfo) {    
        fireOnPreWrite("populationSeasonInfo", null, populationSeasonInfo);
        if (this.populationSeasonInfo == null) {
            this.populationSeasonInfo = new ArrayList<PopulationSeasonInfo>();
        }
        populationSeasonInfo.setPopulation(this);
        this.populationSeasonInfo.add(populationSeasonInfo);
        fireOnPostWrite("populationSeasonInfo", this.populationSeasonInfo.size(), null, populationSeasonInfo);
}

    /**
     * addAllPopulationSeasonInfo :
     * @param values 
     */

    public void addAllPopulationSeasonInfo(List<PopulationSeasonInfo> values) {
        if (values == null) {
            return;
        }
        for (PopulationSeasonInfo item : values) {
            addPopulationSeasonInfo(item);
        }
}

    /**
     * getPopulationSeasonInfoByTopiaId :
     * @param topiaId 
     * @return PopulationSeasonInfo 
     */

    public PopulationSeasonInfo getPopulationSeasonInfoByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(populationSeasonInfo, topiaId);
 }

    /**
     * setPopulationSeasonInfo :
     * @param values 
     */

    public void setPopulationSeasonInfo(List<PopulationSeasonInfo> values) {
        List<PopulationSeasonInfo> _oldValue = populationSeasonInfo;
        fireOnPreWrite("populationSeasonInfo", _oldValue, values);
        populationSeasonInfo = values;
        fireOnPostWrite("populationSeasonInfo", _oldValue, values);
}

    /**
     * removePopulationSeasonInfo :
     * @param value 
     */

    public void removePopulationSeasonInfo(PopulationSeasonInfo value) {
        fireOnPreWrite("populationSeasonInfo", value, null);
        if ((this.populationSeasonInfo == null) || (!this.populationSeasonInfo.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setPopulation(null);
        fireOnPostWrite("populationSeasonInfo", this.populationSeasonInfo.size()+1, value, null);
}

    /**
     * clearPopulationSeasonInfo :
     */

    public void clearPopulationSeasonInfo() {
        if (this.populationSeasonInfo == null) {
            return;
        }
        for (PopulationSeasonInfo item : this.populationSeasonInfo) {
            item.setPopulation(null);
        }
        List<PopulationSeasonInfo> _oldValue = new ArrayList<PopulationSeasonInfo>(this.populationSeasonInfo);
        fireOnPreWrite("populationSeasonInfo", _oldValue, this.populationSeasonInfo);
        this.populationSeasonInfo.clear();
        fireOnPostWrite("populationSeasonInfo", _oldValue, this.populationSeasonInfo);
}

    /**
     * getPopulationSeasonInfo :
     * @return List<PopulationSeasonInfo> 
     */

    public List<PopulationSeasonInfo> getPopulationSeasonInfo() {
        return populationSeasonInfo;
}

    /**
     * sizePopulationSeasonInfo :
     * @return int 
     */

    public int sizePopulationSeasonInfo() {
        if (populationSeasonInfo == null) {
            return 0;
        }
        return populationSeasonInfo.size();
}

    /**
     * isPopulationSeasonInfoEmpty :
     * @return boolean 
     */

    public boolean isPopulationSeasonInfoEmpty() {
        int size = sizePopulationSeasonInfo();
        return size == 0;
}

    /**
     * setSpecies :
     * @param value 
     */

    public void setSpecies(Species value) {
        Species _oldValue = this.species;
        fireOnPreWrite("species", _oldValue, value);
        this.species = value;
        fireOnPostWrite("species", _oldValue, value);
}

    /**
     * getSpecies :
     * @return Species 
     */

    public Species getSpecies() {
        fireOnPreRead("species", species);
        Species result = this.species;
        fireOnPostRead("species", species);
        return result;
}

    /**
     * addReproductionZone :
     * @param reproductionZone 
     */

    public void addReproductionZone(Zone reproductionZone) {    
        fireOnPreWrite("reproductionZone", null, reproductionZone);
        if (this.reproductionZone == null) {
            this.reproductionZone = new ArrayList<Zone>();
        }
        this.reproductionZone.add(reproductionZone);
        fireOnPostWrite("reproductionZone", this.reproductionZone.size(), null, reproductionZone);
}

    /**
     * addAllReproductionZone :
     * @param values 
     */

    public void addAllReproductionZone(List<Zone> values) {
        if (values == null) {
            return;
        }
        for (Zone item : values) {
            addReproductionZone(item);
        }
}

    /**
     * getReproductionZoneByTopiaId :
     * @param topiaId 
     * @return Zone 
     */

    public Zone getReproductionZoneByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(reproductionZone, topiaId);
 }

    /**
     * setReproductionZone :
     * @param values 
     */

    public void setReproductionZone(List<Zone> values) {
        List<Zone> _oldValue = reproductionZone;
        fireOnPreWrite("reproductionZone", _oldValue, values);
        reproductionZone = values;
        fireOnPostWrite("reproductionZone", _oldValue, values);
}

    /**
     * removeReproductionZone :
     * @param value 
     */

    public void removeReproductionZone(Zone value) {
        fireOnPreWrite("reproductionZone", value, null);
        if ((this.reproductionZone == null) || (!this.reproductionZone.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        fireOnPostWrite("reproductionZone", this.reproductionZone.size()+1, value, null);
}

    /**
     * clearReproductionZone :
     */

    public void clearReproductionZone() {
        if (this.reproductionZone == null) {
            return;
        }
        List<Zone> _oldValue = new ArrayList<Zone>(this.reproductionZone);
        fireOnPreWrite("reproductionZone", _oldValue, this.reproductionZone);
        this.reproductionZone.clear();
        fireOnPostWrite("reproductionZone", _oldValue, this.reproductionZone);
}

    /**
     * getReproductionZone :
     * @return List<Zone> 
     */

    public List<Zone> getReproductionZone() {
        return reproductionZone;
}

    /**
     * sizeReproductionZone :
     * @return int 
     */

    public int sizeReproductionZone() {
        if (reproductionZone == null) {
            return 0;
        }
        return reproductionZone.size();
}

    /**
     * isReproductionZoneEmpty :
     * @return boolean 
     */

    public boolean isReproductionZoneEmpty() {
        int size = sizeReproductionZone();
        return size == 0;
}

    /**
     * addPopulationZone :
     * @param populationZone 
     */

    public void addPopulationZone(Zone populationZone) {    
        fireOnPreWrite("populationZone", null, populationZone);
        if (this.populationZone == null) {
            this.populationZone = new ArrayList<Zone>();
        }
        this.populationZone.add(populationZone);
        fireOnPostWrite("populationZone", this.populationZone.size(), null, populationZone);
}

    /**
     * addAllPopulationZone :
     * @param values 
     */

    public void addAllPopulationZone(List<Zone> values) {
        if (values == null) {
            return;
        }
        for (Zone item : values) {
            addPopulationZone(item);
        }
}

    /**
     * getPopulationZoneByTopiaId :
     * @param topiaId 
     * @return Zone 
     */

    public Zone getPopulationZoneByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(populationZone, topiaId);
 }

    /**
     * setPopulationZone :
     * @param values 
     */

    public void setPopulationZone(List<Zone> values) {
        List<Zone> _oldValue = populationZone;
        fireOnPreWrite("populationZone", _oldValue, values);
        populationZone = values;
        fireOnPostWrite("populationZone", _oldValue, values);
}

    /**
     * removePopulationZone :
     * @param value 
     */

    public void removePopulationZone(Zone value) {
        fireOnPreWrite("populationZone", value, null);
        if ((this.populationZone == null) || (!this.populationZone.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        fireOnPostWrite("populationZone", this.populationZone.size()+1, value, null);
}

    /**
     * clearPopulationZone :
     */

    public void clearPopulationZone() {
        if (this.populationZone == null) {
            return;
        }
        List<Zone> _oldValue = new ArrayList<Zone>(this.populationZone);
        fireOnPreWrite("populationZone", _oldValue, this.populationZone);
        this.populationZone.clear();
        fireOnPostWrite("populationZone", _oldValue, this.populationZone);
}

    /**
     * getPopulationZone :
     * @return List<Zone> 
     */

    public List<Zone> getPopulationZone() {
        return populationZone;
}

    /**
     * sizePopulationZone :
     * @return int 
     */

    public int sizePopulationZone() {
        if (populationZone == null) {
            return 0;
        }
        return populationZone.size();
}

    /**
     * isPopulationZoneEmpty :
     * @return boolean 
     */

    public boolean isPopulationZoneEmpty() {
        int size = sizePopulationZone();
        return size == 0;
}

    /**
     * addRecruitmentZone :
     * @param recruitmentZone 
     */

    public void addRecruitmentZone(Zone recruitmentZone) {    
        fireOnPreWrite("recruitmentZone", null, recruitmentZone);
        if (this.recruitmentZone == null) {
            this.recruitmentZone = new ArrayList<Zone>();
        }
        this.recruitmentZone.add(recruitmentZone);
        fireOnPostWrite("recruitmentZone", this.recruitmentZone.size(), null, recruitmentZone);
}

    /**
     * addAllRecruitmentZone :
     * @param values 
     */

    public void addAllRecruitmentZone(List<Zone> values) {
        if (values == null) {
            return;
        }
        for (Zone item : values) {
            addRecruitmentZone(item);
        }
}

    /**
     * getRecruitmentZoneByTopiaId :
     * @param topiaId 
     * @return Zone 
     */

    public Zone getRecruitmentZoneByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(recruitmentZone, topiaId);
 }

    /**
     * setRecruitmentZone :
     * @param values 
     */

    public void setRecruitmentZone(List<Zone> values) {
        List<Zone> _oldValue = recruitmentZone;
        fireOnPreWrite("recruitmentZone", _oldValue, values);
        recruitmentZone = values;
        fireOnPostWrite("recruitmentZone", _oldValue, values);
}

    /**
     * removeRecruitmentZone :
     * @param value 
     */

    public void removeRecruitmentZone(Zone value) {
        fireOnPreWrite("recruitmentZone", value, null);
        if ((this.recruitmentZone == null) || (!this.recruitmentZone.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        fireOnPostWrite("recruitmentZone", this.recruitmentZone.size()+1, value, null);
}

    /**
     * clearRecruitmentZone :
     */

    public void clearRecruitmentZone() {
        if (this.recruitmentZone == null) {
            return;
        }
        List<Zone> _oldValue = new ArrayList<Zone>(this.recruitmentZone);
        fireOnPreWrite("recruitmentZone", _oldValue, this.recruitmentZone);
        this.recruitmentZone.clear();
        fireOnPostWrite("recruitmentZone", _oldValue, this.recruitmentZone);
}

    /**
     * getRecruitmentZone :
     * @return List<Zone> 
     */

    public List<Zone> getRecruitmentZone() {
        return recruitmentZone;
}

    /**
     * sizeRecruitmentZone :
     * @return int 
     */

    public int sizeRecruitmentZone() {
        if (recruitmentZone == null) {
            return 0;
        }
        return recruitmentZone.size();
}

    /**
     * isRecruitmentZoneEmpty :
     * @return boolean 
     */

    public boolean isRecruitmentZoneEmpty() {
        int size = sizeRecruitmentZone();
        return size == 0;
}

    /**
     * setMaturityGroup :
     * @param value 
     */

    public void setMaturityGroup(PopulationGroup value) {
        PopulationGroup _oldValue = this.maturityGroup;
        fireOnPreWrite("maturityGroup", _oldValue, value);
        this.maturityGroup = value;
        fireOnPostWrite("maturityGroup", _oldValue, value);
}

    /**
     * getMaturityGroup :
     * @return PopulationGroup 
     */

    public PopulationGroup getMaturityGroup() {
        fireOnPreRead("maturityGroup", maturityGroup);
        PopulationGroup result = this.maturityGroup;
        fireOnPostRead("maturityGroup", maturityGroup);
        return result;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
            append("geographicId", this.geographicId).
            append("plusGroup", this.plusGroup).
            append("growth", this.growth).
            append("growthReverse", this.growthReverse).
            append("comment", this.comment).
            append("meanWeight", this.meanWeight).
            append("price", this.price).
            append("naturalDeathRate", this.naturalDeathRate).
            append("caractBioComment", this.caractBioComment).
            append("reproductionEquation", this.reproductionEquation).
            append("monthGapBetweenReproRecrutement", this.monthGapBetweenReproRecrutement).
            append("recruitmentDistribution", this.recruitmentDistribution).
            append("recruitmentComment", this.recruitmentComment).
            append("zonesComment", this.zonesComment).
            append("seasonsComment", this.seasonsComment).
            append("capturabilityComment", this.capturabilityComment).
            append("migrationComment", this.migrationComment).
            append("mappingZoneReproZoneRecru", this.mappingZoneReproZoneRecru).
            append("capturability", this.capturability).
            append("populationGroup", this.populationGroup).
            append("reproductionZone", this.reproductionZone).
            append("populationZone", this.populationZone).
            append("recruitmentZone", this.recruitmentZone).
            append("maturityGroup", this.maturityGroup).
         toString();
        return result;
}


} //PopulationAbstract
