/* *##%
 * Copyright (C) 2006 - 2009
 *     Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.entities;

import static org.nuiton.i18n.I18n._;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * MetierSeasonInfoImpl.
 *
 * Created: 23 août 2006 16:25:40
 *
 * @author poussin
 * @version $Revision: 2658 $
 *
 * Last update: $Date: 2009-10-13 17:00:50 +0200 (mar., 13 oct. 2009) $
 * by : $Author: chatellier $
 */
public class MetierSeasonInfoImpl extends MetierSeasonInfoAbstract {

    /** serialVersionUID. */
    private static final long serialVersionUID = 4554500494092542926L;

    /** Logger for this class. */
    private static final Log log = LogFactory
            .getLog(MetierSeasonInfoImpl.class);

    /*
     * @see fr.ifremer.isisfish.entities.MetierSeasonInfo#targetFactor(fr.ifremer.isisfish.entities.PopulationGroup)
     */
    @Override
    public double getTargetFactor(PopulationGroup group) {
        // Par defaut on retourne 1 si dans les donnes rien n'est
        // precisé (20041108: Stef + dom)
        double result = 1;

        Species species = group.getPopulation().getSpecies();
        TargetSpecies targetSpecies = this.getSpeciesTargetSpecies(species);
        if (targetSpecies != null) {
            result = targetSpecies.getTargetFactor(group);
        } else {
            if (log.isDebugEnabled()) {
                log.debug(_("isisfish.error.no.target.species", this, group));
            }
        }
        return result;
    }

    @Override
    public List<Cell> getCells() {
        List<Cell> result = new ArrayList<Cell>();
        for (Zone zone : getZone()) {
            result.addAll(zone.getCell());
        }
        return result;
    }

    /*
     * @see fr.ifremer.isisfish.entities.FisheryRegionAbstract#toString()
     */
    @Override
    public String toString() {
        String result = _("isisfish.metierSeasonInfo.toString", this
                .getMetier(), this.getFirstMonth(), this.getLastMonth());
        return result;
    }

}
