package fr.ifremer.isisfish.entities;

import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;


public abstract class MetierSeasonInfoDAOAbstract<E extends MetierSeasonInfo> extends SeasonDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)MetierSeasonInfo.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findBySeasonZoneComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut seasonZoneComment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findBySeasonZoneComment(String v) throws TopiaException {
        E result = findByProperty("seasonZoneComment", v);
        return result;
    }

    /**
     * findAllBySeasonZoneComment :
     * Retourne les éléments ayant comme valeur pour l'attribut seasonZoneComment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllBySeasonZoneComment(String v) throws TopiaException {
        List<E> result = findAllByProperty("seasonZoneComment", v);
        return result;
    }

    /**
     * findByComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty("comment", v);
        return result;
    }

    /**
     * findAllByComment :
     * Retourne les éléments ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty("comment", v);
        return result;
    }

    /**
     * findContainsSpecies :
     * Retourne le premier élément trouvé dont l'attribut species contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsSpecies(Species... v) throws TopiaException {
        E result = findContainsProperties("species", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsSpecies :
     * Retourne les éléments trouvé dont l'attribut species contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsSpecies(Species... v) throws TopiaException {
        List<E> results = findAllContainsProperties("species", Arrays.asList(v));
        return results;
    }

    /**
     * findByMetier :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut metier le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMetier(Metier v) throws TopiaException {
        E result = findByProperty("metier", v);
        return result;
    }

    /**
     * findAllByMetier :
     * Retourne les éléments ayant comme valeur pour l'attribut metier le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMetier(Metier v) throws TopiaException {
        List<E> result = findAllByProperty("metier", v);
        return result;
    }

    /**
     * findContainsZone :
     * Retourne le premier élément trouvé dont l'attribut zone contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsZone(Zone... v) throws TopiaException {
        E result = findContainsProperties("zone", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsZone :
     * Retourne les éléments trouvé dont l'attribut zone contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsZone(Zone... v) throws TopiaException {
        List<E> results = findAllContainsProperties("zone", Arrays.asList(v));
        return results;
    }


} //MetierSeasonInfoDAOAbstract<E extends MetierSeasonInfo>
