package fr.ifremer.isisfish.entities;

import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class MetierDAOAbstract<E extends Metier> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Metier.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
                {
                List<fr.ifremer.isisfish.entities.MetierSeasonInfo> list = getContext()
                            .getDAO(fr.ifremer.isisfish.entities.MetierSeasonInfo.class)
                            .findAllByProperties("metier", entity);
                    for (fr.ifremer.isisfish.entities.MetierSeasonInfo item : list) {
                        item.setMetier(null);

                    }
                }

        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty("name", v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty("name", v);
        return result;
    }

    /**
     * findByGearParameterValue :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut gearParameterValue le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByGearParameterValue(String v) throws TopiaException {
        E result = findByProperty("gearParameterValue", v);
        return result;
    }

    /**
     * findAllByGearParameterValue :
     * Retourne les éléments ayant comme valeur pour l'attribut gearParameterValue le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByGearParameterValue(String v) throws TopiaException {
        List<E> result = findAllByProperty("gearParameterValue", v);
        return result;
    }

    /**
     * findByComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty("comment", v);
        return result;
    }

    /**
     * findAllByComment :
     * Retourne les éléments ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty("comment", v);
        return result;
    }

    /**
     * findByCapturableSpeciesComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut capturableSpeciesComment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCapturableSpeciesComment(String v) throws TopiaException {
        E result = findByProperty("capturableSpeciesComment", v);
        return result;
    }

    /**
     * findAllByCapturableSpeciesComment :
     * Retourne les éléments ayant comme valeur pour l'attribut capturableSpeciesComment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCapturableSpeciesComment(String v) throws TopiaException {
        List<E> result = findAllByProperty("capturableSpeciesComment", v);
        return result;
    }

    /**
     * findByGear :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut gear le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByGear(Gear v) throws TopiaException {
        E result = findByProperty("gear", v);
        return result;
    }

    /**
     * findAllByGear :
     * Retourne les éléments ayant comme valeur pour l'attribut gear le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByGear(Gear v) throws TopiaException {
        List<E> result = findAllByProperty("gear", v);
        return result;
    }

    /**
     * findContainsMetierSeasonInfo :
     * Retourne le premier élément trouvé dont l'attribut metierSeasonInfo contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsMetierSeasonInfo(MetierSeasonInfo... v) throws TopiaException {
        E result = findContainsProperties("metierSeasonInfo", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsMetierSeasonInfo :
     * Retourne les éléments trouvé dont l'attribut metierSeasonInfo contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsMetierSeasonInfo(MetierSeasonInfo... v) throws TopiaException {
        List<E> results = findAllContainsProperties("metierSeasonInfo", Arrays.asList(v));
        return results;
    }


} //MetierDAOAbstract<E extends Metier>
