package fr.ifremer.isisfish.entities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class MetierAbstract extends TopiaEntityAbstract implements Metier {

    private String name;
    private String gearParameterValue;
    private String comment;
    private String capturableSpeciesComment;
    public Gear gear;
    public Collection<EffortDescription> setOfVesselsEffortDescription;
    public List<MetierSeasonInfo> metierSeasonInfo;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Metier.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Metier.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "name", String.class, name);
        visitor.visit(this, "gearParameterValue", String.class, gearParameterValue);
        visitor.visit(this, "comment", String.class, comment);
        visitor.visit(this, "capturableSpeciesComment", String.class, capturableSpeciesComment);
        visitor.visit(this, "gear", Gear.class, gear);
        visitor.visit(this, "setOfVesselsEffortDescription", java.util.Collection.class, EffortDescription.class, setOfVesselsEffortDescription);
        visitor.visit(this, "metierSeasonInfo", List.class, MetierSeasonInfo.class, metierSeasonInfo);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        {
            org.nuiton.topia.persistence.TopiaDAO<EffortDescription> dao = ((TopiaContextImplementor) getTopiaContext()).getDAO(EffortDescription.class);
            List<EffortDescription> findAllByProperties = dao.findAllByProperties("possibleMetiers", this);
            if (findAllByProperties != null) {
                tmp.addAll(findAllByProperties);
            }
        }
        if (getMetierSeasonInfo() != null) {
              tmp.addAll(getMetierSeasonInfo());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        fireOnPostWrite("name", _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead("name", name);
        String result = this.name;
        fireOnPostRead("name", name);
        return result;
}

    /**
     * setGearParameterValue :
     * @param value 
     */

    public void setGearParameterValue(String value) {
        String _oldValue = this.gearParameterValue;
        fireOnPreWrite("gearParameterValue", _oldValue, value);
        this.gearParameterValue = value;
        fireOnPostWrite("gearParameterValue", _oldValue, value);
}

    /**
     * getGearParameterValue :
     * @return String 
     */

    public String getGearParameterValue() {
        fireOnPreRead("gearParameterValue", gearParameterValue);
        String result = this.gearParameterValue;
        fireOnPostRead("gearParameterValue", gearParameterValue);
        return result;
}

    /**
     * setComment :
     * @param value 
     */

    public void setComment(String value) {
        String _oldValue = this.comment;
        fireOnPreWrite("comment", _oldValue, value);
        this.comment = value;
        fireOnPostWrite("comment", _oldValue, value);
}

    /**
     * getComment :
     * @return String 
     */

    public String getComment() {
        fireOnPreRead("comment", comment);
        String result = this.comment;
        fireOnPostRead("comment", comment);
        return result;
}

    /**
     * setCapturableSpeciesComment :
     * @param value 
     */

    public void setCapturableSpeciesComment(String value) {
        String _oldValue = this.capturableSpeciesComment;
        fireOnPreWrite("capturableSpeciesComment", _oldValue, value);
        this.capturableSpeciesComment = value;
        fireOnPostWrite("capturableSpeciesComment", _oldValue, value);
}

    /**
     * getCapturableSpeciesComment :
     * @return String 
     */

    public String getCapturableSpeciesComment() {
        fireOnPreRead("capturableSpeciesComment", capturableSpeciesComment);
        String result = this.capturableSpeciesComment;
        fireOnPostRead("capturableSpeciesComment", capturableSpeciesComment);
        return result;
}

    /**
     * setGear :
     * @param value 
     */

    public void setGear(Gear value) {
        Gear _oldValue = this.gear;
        fireOnPreWrite("gear", _oldValue, value);
        this.gear = value;
        fireOnPostWrite("gear", _oldValue, value);
}

    /**
     * getGear :
     * @return Gear 
     */

    public Gear getGear() {
        fireOnPreRead("gear", gear);
        Gear result = this.gear;
        fireOnPostRead("gear", gear);
        return result;
}

    /**
     * addMetierSeasonInfo :
     * @param metierSeasonInfo 
     */

    public void addMetierSeasonInfo(MetierSeasonInfo metierSeasonInfo) {    
        fireOnPreWrite("metierSeasonInfo", null, metierSeasonInfo);
        if (this.metierSeasonInfo == null) {
            this.metierSeasonInfo = new ArrayList<MetierSeasonInfo>();
        }
        metierSeasonInfo.setMetier(this);
        this.metierSeasonInfo.add(metierSeasonInfo);
        fireOnPostWrite("metierSeasonInfo", this.metierSeasonInfo.size(), null, metierSeasonInfo);
}

    /**
     * addAllMetierSeasonInfo :
     * @param values 
     */

    public void addAllMetierSeasonInfo(List<MetierSeasonInfo> values) {
        if (values == null) {
            return;
        }
        for (MetierSeasonInfo item : values) {
            addMetierSeasonInfo(item);
        }
}

    /**
     * getMetierSeasonInfoByTopiaId :
     * @param topiaId 
     * @return MetierSeasonInfo 
     */

    public MetierSeasonInfo getMetierSeasonInfoByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(metierSeasonInfo, topiaId);
 }

    /**
     * setMetierSeasonInfo :
     * @param values 
     */

    public void setMetierSeasonInfo(List<MetierSeasonInfo> values) {
        List<MetierSeasonInfo> _oldValue = metierSeasonInfo;
        fireOnPreWrite("metierSeasonInfo", _oldValue, values);
        metierSeasonInfo = values;
        fireOnPostWrite("metierSeasonInfo", _oldValue, values);
}

    /**
     * removeMetierSeasonInfo :
     * @param value 
     */

    public void removeMetierSeasonInfo(MetierSeasonInfo value) {
        fireOnPreWrite("metierSeasonInfo", value, null);
        if ((this.metierSeasonInfo == null) || (!this.metierSeasonInfo.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setMetier(null);
        fireOnPostWrite("metierSeasonInfo", this.metierSeasonInfo.size()+1, value, null);
}

    /**
     * clearMetierSeasonInfo :
     */

    public void clearMetierSeasonInfo() {
        if (this.metierSeasonInfo == null) {
            return;
        }
        for (MetierSeasonInfo item : this.metierSeasonInfo) {
            item.setMetier(null);
        }
        List<MetierSeasonInfo> _oldValue = new ArrayList<MetierSeasonInfo>(this.metierSeasonInfo);
        fireOnPreWrite("metierSeasonInfo", _oldValue, this.metierSeasonInfo);
        this.metierSeasonInfo.clear();
        fireOnPostWrite("metierSeasonInfo", _oldValue, this.metierSeasonInfo);
}

    /**
     * getMetierSeasonInfo :
     * @return List<MetierSeasonInfo> 
     */

    public List<MetierSeasonInfo> getMetierSeasonInfo() {
        return metierSeasonInfo;
}

    /**
     * sizeMetierSeasonInfo :
     * @return int 
     */

    public int sizeMetierSeasonInfo() {
        if (metierSeasonInfo == null) {
            return 0;
        }
        return metierSeasonInfo.size();
}

    /**
     * isMetierSeasonInfoEmpty :
     * @return boolean 
     */

    public boolean isMetierSeasonInfoEmpty() {
        int size = sizeMetierSeasonInfo();
        return size == 0;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
            append("gearParameterValue", this.gearParameterValue).
            append("comment", this.comment).
            append("capturableSpeciesComment", this.capturableSpeciesComment).
            append("gear", this.gear).
         toString();
        return result;
}


} //MetierAbstract
