package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.Month;
import java.util.List;
import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields (
  txtFields={"name","gearParameterValue","comment","capturableSpeciesComment"}
)

public interface Metier extends TopiaEntity {     String NAME = "name";
     String GEAR_PARAMETER_VALUE = "gearParameterValue";
     String COMMENT = "comment";
     String CAPTURABLE_SPECIES_COMMENT = "capturableSpeciesComment";
     String GEAR = "gear";
     String SET_OF_VESSELS_EFFORT_DESCRIPTION = "setOfVesselsEffortDescription";
     String METIER_SEASON_INFO = "metierSeasonInfo";
    /**
     * setName :
     * @param name La valeur de l'attribut name à positionner.
     */

     void setName(String name);

    /**
     * getName :
     * @return String 
     */

     String getName();

    /**
     * setGearParameterValue :
     * @param gearParameterValue La valeur de l'attribut gearParameterValue à positionner.
     */

     void setGearParameterValue(String gearParameterValue);

    /**
     * getGearParameterValue :
     * @return String 
     */

     String getGearParameterValue();

    /**
     * setComment :
     * @param comment La valeur de l'attribut comment à positionner.
     */

     void setComment(String comment);

    /**
     * getComment :
     * @return String 
     */

     String getComment();

    /**
     * setCapturableSpeciesComment :
     * @param capturableSpeciesComment La valeur de l'attribut capturableSpeciesComment à positionner.
     */

     void setCapturableSpeciesComment(String capturableSpeciesComment);

    /**
     * getCapturableSpeciesComment :
     * @return String 
     */

     String getCapturableSpeciesComment();

    /**
     * setGear :
     * @param gear La valeur de l'attribut gear à positionner.
     */

     void setGear(Gear gear);

    /**
     * getGear :
     * @return Gear 
     */

     Gear getGear();

    /**
     * addMetierSeasonInfo :
     * @param metierSeasonInfo L'instance de metierSeasonInfo à ajouter
     */

     void addMetierSeasonInfo(MetierSeasonInfo metierSeasonInfo);

    /**
     * addAllMetierSeasonInfo :
     * @param metierSeasonInfo Les instances de metierSeasonInfo à ajouter
     */

     void addAllMetierSeasonInfo(List<MetierSeasonInfo> metierSeasonInfo);

    /**
     * setMetierSeasonInfo :
     * @param metierSeasonInfo La Collection de metierSeasonInfo à ajouter
     */

     void setMetierSeasonInfo(List<MetierSeasonInfo> metierSeasonInfo);

    /**
     * removeMetierSeasonInfo :
     * @param metierSeasonInfo Vide la Collection de metierSeasonInfo
     */

     void removeMetierSeasonInfo(MetierSeasonInfo metierSeasonInfo);

    /**
     * clearMetierSeasonInfo :
     */

     void clearMetierSeasonInfo();

    /**
     * getMetierSeasonInfo :
     * @return List<MetierSeasonInfo> 
     */

     List<MetierSeasonInfo> getMetierSeasonInfo();

    /**
     * getMetierSeasonInfoByTopiaId :
     * Recupère l'attribut metierSeasonInfo à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return MetierSeasonInfo 
     */

     MetierSeasonInfo getMetierSeasonInfoByTopiaId(String topiaId);

    /**
     * sizeMetierSeasonInfo :
     * Retourne le nombre d'éléments de la collection metierSeasonInfo
     * @return int 
     */

     int sizeMetierSeasonInfo();

    /**
     * isMetierSeasonInfoEmpty :
     * Retourne {@code true} si la collection metierSeasonInfo est vide.
     * @return boolean 
     */

     boolean isMetierSeasonInfoEmpty();

    /**
     * getFisheryRegion :
     * @return FisheryRegion 
     */

     FisheryRegion getFisheryRegion();

    /**
     * getMetierSeasonInfo :
     * @param month 
     * @return MetierSeasonInfo 
     */

     MetierSeasonInfo getMetierSeasonInfo(Month month);

    /**
     * getGearParameterValueAsDouble :
     * @return double 
     */

     double getGearParameterValueAsDouble();


} //Metier
