package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.RangeOfValues;
import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class GearDAOAbstract<E extends Gear> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Gear.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
                {
                List<fr.ifremer.isisfish.entities.Metier> list = getContext()
                            .getDAO(fr.ifremer.isisfish.entities.Metier.class)
                            .findAllByProperties("gear", entity);
                    for (fr.ifremer.isisfish.entities.Metier item : list) {
                        item.setGear(null);

                    }
                }

        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty("name", v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty("name", v);
        return result;
    }

    /**
     * findByEffortUnit :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut effortUnit le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByEffortUnit(String v) throws TopiaException {
        E result = findByProperty("effortUnit", v);
        return result;
    }

    /**
     * findAllByEffortUnit :
     * Retourne les éléments ayant comme valeur pour l'attribut effortUnit le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByEffortUnit(String v) throws TopiaException {
        List<E> result = findAllByProperty("effortUnit", v);
        return result;
    }

    /**
     * findByStandardisationFactor :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut standardisationFactor le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByStandardisationFactor(double v) throws TopiaException {
        E result = findByProperty("standardisationFactor", v);
        return result;
    }

    /**
     * findAllByStandardisationFactor :
     * Retourne les éléments ayant comme valeur pour l'attribut standardisationFactor le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByStandardisationFactor(double v) throws TopiaException {
        List<E> result = findAllByProperty("standardisationFactor", v);
        return result;
    }

    /**
     * findByParameterName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut parameterName le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByParameterName(String v) throws TopiaException {
        E result = findByProperty("parameterName", v);
        return result;
    }

    /**
     * findAllByParameterName :
     * Retourne les éléments ayant comme valeur pour l'attribut parameterName le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByParameterName(String v) throws TopiaException {
        List<E> result = findAllByProperty("parameterName", v);
        return result;
    }

    /**
     * findByCost :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut cost le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCost(double v) throws TopiaException {
        E result = findByProperty("cost", v);
        return result;
    }

    /**
     * findAllByCost :
     * Retourne les éléments ayant comme valeur pour l'attribut cost le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCost(double v) throws TopiaException {
        List<E> result = findAllByProperty("cost", v);
        return result;
    }

    /**
     * findByPossibleValue :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut possibleValue le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByPossibleValue(RangeOfValues v) throws TopiaException {
        E result = findByProperty("possibleValue", v);
        return result;
    }

    /**
     * findAllByPossibleValue :
     * Retourne les éléments ayant comme valeur pour l'attribut possibleValue le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByPossibleValue(RangeOfValues v) throws TopiaException {
        List<E> result = findAllByProperty("possibleValue", v);
        return result;
    }

    /**
     * findByComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty("comment", v);
        return result;
    }

    /**
     * findAllByComment :
     * Retourne les éléments ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty("comment", v);
        return result;
    }

    /**
     * findContainsPopulation :
     * Retourne le premier élément trouvé dont l'attribut population contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsPopulation(Population... v) throws TopiaException {
        E result = findContainsProperties("population", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsPopulation :
     * Retourne les éléments trouvé dont l'attribut population contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsPopulation(Population... v) throws TopiaException {
        List<E> results = findAllContainsProperties("population", Arrays.asList(v));
        return results;
    }


} //GearDAOAbstract<E extends Gear>
