package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.RangeOfValues;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class GearAbstract extends TopiaEntityAbstract implements Gear {

    private String name;
    private String effortUnit;
    private double standardisationFactor;
    private String parameterName;
    /**
     * <p>Co&ucirc;t d'achat de l'engin</p>


     */
    private double cost;
    private RangeOfValues possibleValue;
    private String comment;
    public Collection<Selectivity> populationSelectivity;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Gear.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Gear.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "name", String.class, name);
        visitor.visit(this, "effortUnit", String.class, effortUnit);
        visitor.visit(this, "standardisationFactor", double.class, standardisationFactor);
        visitor.visit(this, "parameterName", String.class, parameterName);
        visitor.visit(this, "cost", double.class, cost);
        visitor.visit(this, "possibleValue", RangeOfValues.class, possibleValue);
        visitor.visit(this, "comment", String.class, comment);
        visitor.visit(this, "populationSelectivity", java.util.Collection.class, Selectivity.class, populationSelectivity);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        {
            org.nuiton.topia.persistence.TopiaDAO<Selectivity> dao = ((TopiaContextImplementor) getTopiaContext()).getDAO(Selectivity.class);
            List<Selectivity> findAllByProperties = dao.findAllByProperties("gear", this);
            if (findAllByProperties != null) {
                tmp.addAll(findAllByProperties);
            }
        }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        fireOnPostWrite("name", _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead("name", name);
        String result = this.name;
        fireOnPostRead("name", name);
        return result;
}

    /**
     * setEffortUnit :
     * @param value 
     */

    public void setEffortUnit(String value) {
        String _oldValue = this.effortUnit;
        fireOnPreWrite("effortUnit", _oldValue, value);
        this.effortUnit = value;
        fireOnPostWrite("effortUnit", _oldValue, value);
}

    /**
     * getEffortUnit :
     * @return String 
     */

    public String getEffortUnit() {
        fireOnPreRead("effortUnit", effortUnit);
        String result = this.effortUnit;
        fireOnPostRead("effortUnit", effortUnit);
        return result;
}

    /**
     * setStandardisationFactor :
     * @param value 
     */

    public void setStandardisationFactor(double value) {
        double _oldValue = this.standardisationFactor;
        fireOnPreWrite("standardisationFactor", _oldValue, value);
        this.standardisationFactor = value;
        fireOnPostWrite("standardisationFactor", _oldValue, value);
}

    /**
     * getStandardisationFactor :
     * @return double 
     */

    public double getStandardisationFactor() {
        fireOnPreRead("standardisationFactor", standardisationFactor);
        double result = this.standardisationFactor;
        fireOnPostRead("standardisationFactor", standardisationFactor);
        return result;
}

    /**
     * setParameterName :
     * @param value 
     */

    public void setParameterName(String value) {
        String _oldValue = this.parameterName;
        fireOnPreWrite("parameterName", _oldValue, value);
        this.parameterName = value;
        fireOnPostWrite("parameterName", _oldValue, value);
}

    /**
     * getParameterName :
     * @return String 
     */

    public String getParameterName() {
        fireOnPreRead("parameterName", parameterName);
        String result = this.parameterName;
        fireOnPostRead("parameterName", parameterName);
        return result;
}

    /**
     * setCost :
     * @param value 
     */

    public void setCost(double value) {
        double _oldValue = this.cost;
        fireOnPreWrite("cost", _oldValue, value);
        this.cost = value;
        fireOnPostWrite("cost", _oldValue, value);
}

    /**
     * getCost :
     * @return double 
     */

    public double getCost() {
        fireOnPreRead("cost", cost);
        double result = this.cost;
        fireOnPostRead("cost", cost);
        return result;
}

    /**
     * setPossibleValue :
     * @param value 
     */

    public void setPossibleValue(RangeOfValues value) {
        RangeOfValues _oldValue = this.possibleValue;
        fireOnPreWrite("possibleValue", _oldValue, value);
        this.possibleValue = value;
        fireOnPostWrite("possibleValue", _oldValue, value);
}

    /**
     * getPossibleValue :
     * @return RangeOfValues 
     */

    public RangeOfValues getPossibleValue() {
        fireOnPreRead("possibleValue", possibleValue);
        RangeOfValues result = this.possibleValue;
        fireOnPostRead("possibleValue", possibleValue);
        return result;
}

    /**
     * setComment :
     * @param value 
     */

    public void setComment(String value) {
        String _oldValue = this.comment;
        fireOnPreWrite("comment", _oldValue, value);
        this.comment = value;
        fireOnPostWrite("comment", _oldValue, value);
}

    /**
     * getComment :
     * @return String 
     */

    public String getComment() {
        fireOnPreRead("comment", comment);
        String result = this.comment;
        fireOnPostRead("comment", comment);
        return result;
}

    /**
     * addPopulationSelectivity :
     * @param value 
     */

    public void addPopulationSelectivity(Selectivity value) {
        fireOnPreWrite("populationSelectivity", null, value);
        if (this.populationSelectivity == null) {
            this.populationSelectivity = new ArrayList<fr.ifremer.isisfish.entities.Selectivity>();
        }
        this.populationSelectivity.add(value);
        fireOnPostWrite("populationSelectivity", this.populationSelectivity.size(), null, value);
}

    /**
     * getPopulationSelectivityByTopiaId :
     * @param topiaId 
     * @return Selectivity 
     */

    public Selectivity getPopulationSelectivityByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(populationSelectivity, topiaId);
}

    /**
     * addAllPopulationSelectivity :
     * @param values 
     */

    public void addAllPopulationSelectivity(Collection<Selectivity> values) {
        if (values == null) {
            return;
        }
        for (fr.ifremer.isisfish.entities.Selectivity item : values) {
            addPopulationSelectivity(item);
        }
}

    /**
     * setPopulationSelectivity :
     * @param values 
     */

    public void setPopulationSelectivity(Collection<Selectivity> values) {
//        clearPopulationSelectivity();
//        addAllPopulationSelectivity(values);
// FIXME
        Collection<fr.ifremer.isisfish.entities.Selectivity> _oldValue = populationSelectivity;
        fireOnPreWrite("populationSelectivity", _oldValue, values);
        populationSelectivity = values;
        fireOnPostWrite("populationSelectivity", _oldValue, values);
}

    /**
     * removePopulationSelectivity :
     * @param value 
     */

    public void removePopulationSelectivity(Selectivity value) {
        fireOnPreWrite("populationSelectivity", value, null);
        if ((this.populationSelectivity == null) || (!this.populationSelectivity.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        fireOnPostWrite("populationSelectivity", this.populationSelectivity.size()+1, value, null);
}

    /**
     * clearPopulationSelectivity :
     */

    public void clearPopulationSelectivity() {
        if (this.populationSelectivity == null) {
            return;
        }
        Collection<fr.ifremer.isisfish.entities.Selectivity> _oldValue = new ArrayList<fr.ifremer.isisfish.entities.Selectivity>(this.populationSelectivity);
        fireOnPreWrite("populationSelectivity", _oldValue, null);
        this.populationSelectivity.clear();
        fireOnPostWrite("populationSelectivity", _oldValue, null);
}

    /**
     * getPopulationSelectivity :
     * @return Collection<Selectivity> 
     */

    public Collection<Selectivity> getPopulationSelectivity() {
        return populationSelectivity;
}

    /**
     * getPopulationSelectivity :
     * @param value 
     * @return Selectivity 
     */

    public Selectivity getPopulationSelectivity(Population value) {
        if (value == null || populationSelectivity == null) {
            return null;
        }
        for (fr.ifremer.isisfish.entities.Selectivity item : populationSelectivity) {
            if (value.equals(item.getPopulation())) {
                return item;
            }
        }
        return null;
}

    /**
     * sizePopulationSelectivity :
     * @return int 
     */

    public int sizePopulationSelectivity() {
        if (populationSelectivity == null) {
            return 0;
        }
        return populationSelectivity.size();
}

    /**
     * isPopulationSelectivityEmpty :
     * @return boolean 
     */

    public boolean isPopulationSelectivityEmpty() {
        int size = sizePopulationSelectivity();
        return size == 0;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
            append("effortUnit", this.effortUnit).
            append("standardisationFactor", this.standardisationFactor).
            append("parameterName", this.parameterName).
            append("cost", this.cost).
            append("possibleValue", this.possibleValue).
            append("comment", this.comment).
         toString();
        return result;
}


} //GearAbstract
