package fr.ifremer.isisfish.entities;

import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class FisheryRegionDAOAbstract<E extends FisheryRegion> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)FisheryRegion.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty("name", v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty("name", v);
        return result;
    }

    /**
     * findByMinLongitude :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut minLongitude le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMinLongitude(float v) throws TopiaException {
        E result = findByProperty("minLongitude", v);
        return result;
    }

    /**
     * findAllByMinLongitude :
     * Retourne les éléments ayant comme valeur pour l'attribut minLongitude le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMinLongitude(float v) throws TopiaException {
        List<E> result = findAllByProperty("minLongitude", v);
        return result;
    }

    /**
     * findByMaxLongitude :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut maxLongitude le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMaxLongitude(float v) throws TopiaException {
        E result = findByProperty("maxLongitude", v);
        return result;
    }

    /**
     * findAllByMaxLongitude :
     * Retourne les éléments ayant comme valeur pour l'attribut maxLongitude le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMaxLongitude(float v) throws TopiaException {
        List<E> result = findAllByProperty("maxLongitude", v);
        return result;
    }

    /**
     * findByMinLatitude :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut minLatitude le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMinLatitude(float v) throws TopiaException {
        E result = findByProperty("minLatitude", v);
        return result;
    }

    /**
     * findAllByMinLatitude :
     * Retourne les éléments ayant comme valeur pour l'attribut minLatitude le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMinLatitude(float v) throws TopiaException {
        List<E> result = findAllByProperty("minLatitude", v);
        return result;
    }

    /**
     * findByMaxLatitude :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut maxLatitude le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMaxLatitude(float v) throws TopiaException {
        E result = findByProperty("maxLatitude", v);
        return result;
    }

    /**
     * findAllByMaxLatitude :
     * Retourne les éléments ayant comme valeur pour l'attribut maxLatitude le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMaxLatitude(float v) throws TopiaException {
        List<E> result = findAllByProperty("maxLatitude", v);
        return result;
    }

    /**
     * findByCellLengthLongitude :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut cellLengthLongitude le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCellLengthLongitude(float v) throws TopiaException {
        E result = findByProperty("cellLengthLongitude", v);
        return result;
    }

    /**
     * findAllByCellLengthLongitude :
     * Retourne les éléments ayant comme valeur pour l'attribut cellLengthLongitude le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCellLengthLongitude(float v) throws TopiaException {
        List<E> result = findAllByProperty("cellLengthLongitude", v);
        return result;
    }

    /**
     * findByCellLengthLatitude :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut cellLengthLatitude le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCellLengthLatitude(float v) throws TopiaException {
        E result = findByProperty("cellLengthLatitude", v);
        return result;
    }

    /**
     * findAllByCellLengthLatitude :
     * Retourne les éléments ayant comme valeur pour l'attribut cellLengthLatitude le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCellLengthLatitude(float v) throws TopiaException {
        List<E> result = findAllByProperty("cellLengthLatitude", v);
        return result;
    }

    /**
     * findByMapFiles :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut mapFiles le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMapFiles(String v) throws TopiaException {
        E result = findByProperty("mapFiles", v);
        return result;
    }

    /**
     * findAllByMapFiles :
     * Retourne les éléments ayant comme valeur pour l'attribut mapFiles le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMapFiles(String v) throws TopiaException {
        List<E> result = findAllByProperty("mapFiles", v);
        return result;
    }

    /**
     * findByComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty("comment", v);
        return result;
    }

    /**
     * findAllByComment :
     * Retourne les éléments ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty("comment", v);
        return result;
    }


} //FisheryRegionDAOAbstract<E extends FisheryRegion>
