package fr.ifremer.isisfish.entities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class FisheryRegionAbstract extends TopiaEntityAbstract implements FisheryRegion {

    private String name;
    private float minLongitude;
    private float maxLongitude;
    private float minLatitude;
    private float maxLatitude;
    private float cellLengthLongitude;
    private float cellLengthLatitude;
    private String mapFiles;
    private String comment;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(FisheryRegion.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(FisheryRegion.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "name", String.class, name);
        visitor.visit(this, "minLongitude", float.class, minLongitude);
        visitor.visit(this, "maxLongitude", float.class, maxLongitude);
        visitor.visit(this, "minLatitude", float.class, minLatitude);
        visitor.visit(this, "maxLatitude", float.class, maxLatitude);
        visitor.visit(this, "cellLengthLongitude", float.class, cellLengthLongitude);
        visitor.visit(this, "cellLengthLatitude", float.class, cellLengthLatitude);
        visitor.visit(this, "mapFiles", String.class, mapFiles);
        visitor.visit(this, "comment", String.class, comment);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        fireOnPostWrite("name", _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead("name", name);
        String result = this.name;
        fireOnPostRead("name", name);
        return result;
}

    /**
     * setMinLongitude :
     * @param value 
     */

    public void setMinLongitude(float value) {
        float _oldValue = this.minLongitude;
        fireOnPreWrite("minLongitude", _oldValue, value);
        this.minLongitude = value;
        fireOnPostWrite("minLongitude", _oldValue, value);
}

    /**
     * getMinLongitude :
     * @return float 
     */

    public float getMinLongitude() {
        fireOnPreRead("minLongitude", minLongitude);
        float result = this.minLongitude;
        fireOnPostRead("minLongitude", minLongitude);
        return result;
}

    /**
     * setMaxLongitude :
     * @param value 
     */

    public void setMaxLongitude(float value) {
        float _oldValue = this.maxLongitude;
        fireOnPreWrite("maxLongitude", _oldValue, value);
        this.maxLongitude = value;
        fireOnPostWrite("maxLongitude", _oldValue, value);
}

    /**
     * getMaxLongitude :
     * @return float 
     */

    public float getMaxLongitude() {
        fireOnPreRead("maxLongitude", maxLongitude);
        float result = this.maxLongitude;
        fireOnPostRead("maxLongitude", maxLongitude);
        return result;
}

    /**
     * setMinLatitude :
     * @param value 
     */

    public void setMinLatitude(float value) {
        float _oldValue = this.minLatitude;
        fireOnPreWrite("minLatitude", _oldValue, value);
        this.minLatitude = value;
        fireOnPostWrite("minLatitude", _oldValue, value);
}

    /**
     * getMinLatitude :
     * @return float 
     */

    public float getMinLatitude() {
        fireOnPreRead("minLatitude", minLatitude);
        float result = this.minLatitude;
        fireOnPostRead("minLatitude", minLatitude);
        return result;
}

    /**
     * setMaxLatitude :
     * @param value 
     */

    public void setMaxLatitude(float value) {
        float _oldValue = this.maxLatitude;
        fireOnPreWrite("maxLatitude", _oldValue, value);
        this.maxLatitude = value;
        fireOnPostWrite("maxLatitude", _oldValue, value);
}

    /**
     * getMaxLatitude :
     * @return float 
     */

    public float getMaxLatitude() {
        fireOnPreRead("maxLatitude", maxLatitude);
        float result = this.maxLatitude;
        fireOnPostRead("maxLatitude", maxLatitude);
        return result;
}

    /**
     * setCellLengthLongitude :
     * @param value 
     */

    public void setCellLengthLongitude(float value) {
        float _oldValue = this.cellLengthLongitude;
        fireOnPreWrite("cellLengthLongitude", _oldValue, value);
        this.cellLengthLongitude = value;
        fireOnPostWrite("cellLengthLongitude", _oldValue, value);
}

    /**
     * getCellLengthLongitude :
     * @return float 
     */

    public float getCellLengthLongitude() {
        fireOnPreRead("cellLengthLongitude", cellLengthLongitude);
        float result = this.cellLengthLongitude;
        fireOnPostRead("cellLengthLongitude", cellLengthLongitude);
        return result;
}

    /**
     * setCellLengthLatitude :
     * @param value 
     */

    public void setCellLengthLatitude(float value) {
        float _oldValue = this.cellLengthLatitude;
        fireOnPreWrite("cellLengthLatitude", _oldValue, value);
        this.cellLengthLatitude = value;
        fireOnPostWrite("cellLengthLatitude", _oldValue, value);
}

    /**
     * getCellLengthLatitude :
     * @return float 
     */

    public float getCellLengthLatitude() {
        fireOnPreRead("cellLengthLatitude", cellLengthLatitude);
        float result = this.cellLengthLatitude;
        fireOnPostRead("cellLengthLatitude", cellLengthLatitude);
        return result;
}

    /**
     * setMapFiles :
     * @param value 
     */

    public void setMapFiles(String value) {
        String _oldValue = this.mapFiles;
        fireOnPreWrite("mapFiles", _oldValue, value);
        this.mapFiles = value;
        fireOnPostWrite("mapFiles", _oldValue, value);
}

    /**
     * getMapFiles :
     * @return String 
     */

    public String getMapFiles() {
        fireOnPreRead("mapFiles", mapFiles);
        String result = this.mapFiles;
        fireOnPostRead("mapFiles", mapFiles);
        return result;
}

    /**
     * setComment :
     * @param value 
     */

    public void setComment(String value) {
        String _oldValue = this.comment;
        fireOnPreWrite("comment", _oldValue, value);
        this.comment = value;
        fireOnPostWrite("comment", _oldValue, value);
}

    /**
     * getComment :
     * @return String 
     */

    public String getComment() {
        fireOnPreRead("comment", comment);
        String result = this.comment;
        fireOnPostRead("comment", comment);
        return result;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
            append("minLongitude", this.minLongitude).
            append("maxLongitude", this.maxLongitude).
            append("minLatitude", this.minLatitude).
            append("maxLatitude", this.maxLatitude).
            append("cellLengthLongitude", this.cellLengthLongitude).
            append("cellLengthLatitude", this.cellLengthLatitude).
            append("mapFiles", this.mapFiles).
            append("comment", this.comment).
         toString();
        return result;
}


} //FisheryRegionAbstract
