/* *##%
 * Copyright (C) 2006 - 2009
 *     Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.entities;

import static org.nuiton.i18n.I18n._;

import java.util.HashMap;
import java.util.Map;

import bsh.Interpreter;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.FormuleStorage;
import fr.ifremer.isisfish.equation.Language;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.util.EvaluatorHelper;

/**
 * EquationImpl.
 *
 * Created: 20 janv. 2006 03:43:01
 *
 * @author poussin
 * @version $Revision: 2658 $
 *
 * Last update: $Date: 2009-10-13 17:00:50 +0200 (mar., 13 oct. 2009) $
 * by : $Author: chatellier $
 */
public class EquationImpl extends EquationAbstract {

    /** serialVersionUID. */
    private static final long serialVersionUID = -2195404062556810283L;

    /**
     * Evalue l'equation et retourne le résultat.
     * 
     * @param param equation args
     * @return equation evaluation
     */
    public double evaluate(Map<String, Object> param) {
        String eq = getContent();
        try {
            // add Simulation context in map
            param.put("context", SimulationContext.get());

            // default is BSH
            if (Language.BSH.equals(getLanguage())
                    || (("".equals(getLanguage()) || getLanguage() == null) && getJavaInterface() == null)) {
                Interpreter bsh = new Interpreter();
                for (Map.Entry<String, Object> e : param.entrySet()) {
                    bsh.set(e.getKey(), e.getValue());
                }
                Object val = bsh.eval(eq);
                if (val instanceof Number) {
                    double result = ((Number) val).doubleValue();
                    return result;
                } else {
                    throw new IsisFishRuntimeException(_(
                            "isisfish.error.equation.return.number", eq));
                }
            } else if (Language.JAVA.equals(getLanguage())
                    || getJavaInterface() != null) {
                // default Java if there are javaInterface
                Object val = EvaluatorHelper.evaluate(
                        FormuleStorage.FORMULE_PATH, getTopiaId(),
                        getJavaInterface(), getContent(), param);
                if (val instanceof Number) {
                    double result = ((Number) val).doubleValue();
                    return result;
                } else {
                    throw new IsisFishRuntimeException(_(
                            "isisfish.error.equation.return.number", eq));
                }
            } else {
                // TODO other language support
                throw new IsisFishRuntimeException(_(
                        "isisfish.error.unsupported.equation.langage",
                        getLanguage(), eq));
            }
        } catch (Exception eee) {
            throw new IsisFishRuntimeException(_(
                    "isisfish.error.evaluate.equation", eq), eee);
        }

    }

    public double evaluate(String name, Object value, Object... others) {
        Map<String, Object> param = new HashMap<String, Object>();
        param.put(name, value);
        for (int i = 0; i < others.length;) {
            name = (String) others[i++];
            value = others[i++];
            param.put(name, value);
        }
        double result = evaluate(param);
        return result;
    }

    /*
     * @see fr.ifremer.isisfish.entities.EquationAbstract#toString()
     */
    @Override
    public String toString() {
        String result = getName() + "(" + getCategory() + ")";
        return result;
    }
}
