package fr.ifremer.isisfish.entities;

import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class EquationDAOAbstract<E extends Equation> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Equation.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty("name", v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty("name", v);
        return result;
    }

    /**
     * findByContent :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut content le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByContent(String v) throws TopiaException {
        E result = findByProperty("content", v);
        return result;
    }

    /**
     * findAllByContent :
     * Retourne les éléments ayant comme valeur pour l'attribut content le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByContent(String v) throws TopiaException {
        List<E> result = findAllByProperty("content", v);
        return result;
    }

    /**
     * findByCategory :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut category le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCategory(String v) throws TopiaException {
        E result = findByProperty("category", v);
        return result;
    }

    /**
     * findAllByCategory :
     * Retourne les éléments ayant comme valeur pour l'attribut category le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCategory(String v) throws TopiaException {
        List<E> result = findAllByProperty("category", v);
        return result;
    }

    /**
     * findByLanguage :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut language le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByLanguage(String v) throws TopiaException {
        E result = findByProperty("language", v);
        return result;
    }

    /**
     * findAllByLanguage :
     * Retourne les éléments ayant comme valeur pour l'attribut language le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByLanguage(String v) throws TopiaException {
        List<E> result = findAllByProperty("language", v);
        return result;
    }

    /**
     * findByJavaInterface :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut javaInterface le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByJavaInterface(Class v) throws TopiaException {
        E result = findByProperty("javaInterface", v);
        return result;
    }

    /**
     * findAllByJavaInterface :
     * Retourne les éléments ayant comme valeur pour l'attribut javaInterface le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByJavaInterface(Class v) throws TopiaException {
        List<E> result = findAllByProperty("javaInterface", v);
        return result;
    }


} //EquationDAOAbstract<E extends Equation>
