package fr.ifremer.isisfish.entities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class EquationAbstract extends TopiaEntityAbstract implements Equation {

    private String name;
    private String content;
    private String category;
    private String language;
    private Class javaInterface;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Equation.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Equation.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "name", String.class, name);
        visitor.visit(this, "content", String.class, content);
        visitor.visit(this, "category", String.class, category);
        visitor.visit(this, "language", String.class, language);
        visitor.visit(this, "javaInterface", Class.class, javaInterface);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        fireOnPostWrite("name", _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead("name", name);
        String result = this.name;
        fireOnPostRead("name", name);
        return result;
}

    /**
     * setContent :
     * @param value 
     */

    public void setContent(String value) {
        String _oldValue = this.content;
        fireOnPreWrite("content", _oldValue, value);
        this.content = value;
        fireOnPostWrite("content", _oldValue, value);
}

    /**
     * getContent :
     * @return String 
     */

    public String getContent() {
        fireOnPreRead("content", content);
        String result = this.content;
        fireOnPostRead("content", content);
        return result;
}

    /**
     * setCategory :
     * @param value 
     */

    public void setCategory(String value) {
        String _oldValue = this.category;
        fireOnPreWrite("category", _oldValue, value);
        this.category = value;
        fireOnPostWrite("category", _oldValue, value);
}

    /**
     * getCategory :
     * @return String 
     */

    public String getCategory() {
        fireOnPreRead("category", category);
        String result = this.category;
        fireOnPostRead("category", category);
        return result;
}

    /**
     * setLanguage :
     * @param value 
     */

    public void setLanguage(String value) {
        String _oldValue = this.language;
        fireOnPreWrite("language", _oldValue, value);
        this.language = value;
        fireOnPostWrite("language", _oldValue, value);
}

    /**
     * getLanguage :
     * @return String 
     */

    public String getLanguage() {
        fireOnPreRead("language", language);
        String result = this.language;
        fireOnPostRead("language", language);
        return result;
}

    /**
     * setJavaInterface :
     * @param value 
     */

    public void setJavaInterface(Class value) {
        Class _oldValue = this.javaInterface;
        fireOnPreWrite("javaInterface", _oldValue, value);
        this.javaInterface = value;
        fireOnPostWrite("javaInterface", _oldValue, value);
}

    /**
     * getJavaInterface :
     * @return Class 
     */

    public Class getJavaInterface() {
        fireOnPreRead("javaInterface", javaInterface);
        Class result = this.javaInterface;
        fireOnPostRead("javaInterface", javaInterface);
        return result;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
            append("content", this.content).
            append("category", this.category).
            append("language", this.language).
            append("javaInterface", this.javaInterface).
         toString();
        return result;
}


} //EquationAbstract
