package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.TimeUnit;
import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class EffortDescriptionDAOAbstract<E extends EffortDescription> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)EffortDescription.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByFishingOperation :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut fishingOperation le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByFishingOperation(int v) throws TopiaException {
        E result = findByProperty("fishingOperation", v);
        return result;
    }

    /**
     * findAllByFishingOperation :
     * Retourne les éléments ayant comme valeur pour l'attribut fishingOperation le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByFishingOperation(int v) throws TopiaException {
        List<E> result = findAllByProperty("fishingOperation", v);
        return result;
    }

    /**
     * findByFishingOperationDuration :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut fishingOperationDuration le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByFishingOperationDuration(TimeUnit v) throws TopiaException {
        E result = findByProperty("fishingOperationDuration", v);
        return result;
    }

    /**
     * findAllByFishingOperationDuration :
     * Retourne les éléments ayant comme valeur pour l'attribut fishingOperationDuration le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByFishingOperationDuration(TimeUnit v) throws TopiaException {
        List<E> result = findAllByProperty("fishingOperationDuration", v);
        return result;
    }

    /**
     * findByGearsNumberPerOperation :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut gearsNumberPerOperation le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByGearsNumberPerOperation(int v) throws TopiaException {
        E result = findByProperty("gearsNumberPerOperation", v);
        return result;
    }

    /**
     * findAllByGearsNumberPerOperation :
     * Retourne les éléments ayant comme valeur pour l'attribut gearsNumberPerOperation le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByGearsNumberPerOperation(int v) throws TopiaException {
        List<E> result = findAllByProperty("gearsNumberPerOperation", v);
        return result;
    }

    /**
     * findByCrewSize :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut crewSize le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCrewSize(int v) throws TopiaException {
        E result = findByProperty("crewSize", v);
        return result;
    }

    /**
     * findAllByCrewSize :
     * Retourne les éléments ayant comme valeur pour l'attribut crewSize le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCrewSize(int v) throws TopiaException {
        List<E> result = findAllByProperty("crewSize", v);
        return result;
    }

    /**
     * findByUnitCostOfFishing :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut unitCostOfFishing le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByUnitCostOfFishing(double v) throws TopiaException {
        E result = findByProperty("unitCostOfFishing", v);
        return result;
    }

    /**
     * findAllByUnitCostOfFishing :
     * Retourne les éléments ayant comme valeur pour l'attribut unitCostOfFishing le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByUnitCostOfFishing(double v) throws TopiaException {
        List<E> result = findAllByProperty("unitCostOfFishing", v);
        return result;
    }

    /**
     * findByFixedCrewSalary :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut fixedCrewSalary le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByFixedCrewSalary(double v) throws TopiaException {
        E result = findByProperty("fixedCrewSalary", v);
        return result;
    }

    /**
     * findAllByFixedCrewSalary :
     * Retourne les éléments ayant comme valeur pour l'attribut fixedCrewSalary le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByFixedCrewSalary(double v) throws TopiaException {
        List<E> result = findAllByProperty("fixedCrewSalary", v);
        return result;
    }

    /**
     * findByCrewShareRate :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut crewShareRate le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCrewShareRate(double v) throws TopiaException {
        E result = findByProperty("crewShareRate", v);
        return result;
    }

    /**
     * findAllByCrewShareRate :
     * Retourne les éléments ayant comme valeur pour l'attribut crewShareRate le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCrewShareRate(double v) throws TopiaException {
        List<E> result = findAllByProperty("crewShareRate", v);
        return result;
    }

    /**
     * findByCrewFoodCost :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut crewFoodCost le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCrewFoodCost(double v) throws TopiaException {
        E result = findByProperty("crewFoodCost", v);
        return result;
    }

    /**
     * findAllByCrewFoodCost :
     * Retourne les éléments ayant comme valeur pour l'attribut crewFoodCost le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCrewFoodCost(double v) throws TopiaException {
        List<E> result = findAllByProperty("crewFoodCost", v);
        return result;
    }

    /**
     * findByRepairAndMaintenanceGearCost :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut repairAndMaintenanceGearCost le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByRepairAndMaintenanceGearCost(double v) throws TopiaException {
        E result = findByProperty("repairAndMaintenanceGearCost", v);
        return result;
    }

    /**
     * findAllByRepairAndMaintenanceGearCost :
     * Retourne les éléments ayant comme valeur pour l'attribut repairAndMaintenanceGearCost le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByRepairAndMaintenanceGearCost(double v) throws TopiaException {
        List<E> result = findAllByProperty("repairAndMaintenanceGearCost", v);
        return result;
    }

    /**
     * findByOtherRunningCost :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut otherRunningCost le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByOtherRunningCost(double v) throws TopiaException {
        E result = findByProperty("otherRunningCost", v);
        return result;
    }

    /**
     * findAllByOtherRunningCost :
     * Retourne les éléments ayant comme valeur pour l'attribut otherRunningCost le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByOtherRunningCost(double v) throws TopiaException {
        List<E> result = findAllByProperty("otherRunningCost", v);
        return result;
    }

    /**
     * findByLandingCosts :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut landingCosts le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByLandingCosts(double v) throws TopiaException {
        E result = findByProperty("landingCosts", v);
        return result;
    }

    /**
     * findAllByLandingCosts :
     * Retourne les éléments ayant comme valeur pour l'attribut landingCosts le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByLandingCosts(double v) throws TopiaException {
        List<E> result = findAllByProperty("landingCosts", v);
        return result;
    }

    /**
     * findContainsSetOfVessels :
     * Retourne le premier élément trouvé dont l'attribut setOfVessels contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsSetOfVessels(SetOfVessels... v) throws TopiaException {
        E result = findContainsProperties("setOfVessels", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsSetOfVessels :
     * Retourne les éléments trouvé dont l'attribut setOfVessels contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsSetOfVessels(SetOfVessels... v) throws TopiaException {
        List<E> results = findAllContainsProperties("setOfVessels", Arrays.asList(v));
        return results;
    }

    /**
     * findContainsPossibleMetiers :
     * Retourne le premier élément trouvé dont l'attribut possibleMetiers contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsPossibleMetiers(Metier... v) throws TopiaException {
        E result = findContainsProperties("possibleMetiers", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsPossibleMetiers :
     * Retourne les éléments trouvé dont l'attribut possibleMetiers contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsPossibleMetiers(Metier... v) throws TopiaException {
        List<E> results = findAllContainsProperties("possibleMetiers", Arrays.asList(v));
        return results;
    }


} //EffortDescriptionDAOAbstract<E extends EffortDescription>
