package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.TimeUnit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class EffortDescriptionAbstract extends TopiaEntityAbstract implements EffortDescription {

    /**
     * <p>Nombre d'op&eacute;ration de p&ecirc;che par jour</p>


     */
    private int fishingOperation;
    private TimeUnit fishingOperationDuration;
    private int gearsNumberPerOperation;
    /**
     * <p>Taille de l'&eacute;quipage pour le m&eacute;tier. Ne peut-&ecirc;tre inf&eacute;rieur &agrave; VesselType.minCrewSize.</p>


     */
    private int crewSize;
    /**
     * <p>Co&ucirc;t de fonctionnement li&eacute; &agrave; une op&eacute;ration de p&ecirc;che: carburant, huile, app&acirc;t, glace (hors transport sur zone)</p>


     */
    private double unitCostOfFishing;
    /**
     * <p>Salaire fixe pour l'ensemble de l'&eacute;quipage pour un mois</p>


     */
    private double fixedCrewSalary;
    /**
     * <p>Taux de part de l'&eacute;quipage</p>


     */
    private double crewShareRate;
    /**
     * <p>Frais de vivres pour l'ensemble de l'&eacute;quipage par jour.</p>


     */
    private double crewFoodCost;
    /**
     * <p>Co&ucirc;t de maintenance et de r&eacute;paration par jour d'utilisation</p>


     */
    private double repairAndMaintenanceGearCost;
    /**
     * <p>autres co&ucirc;ts par jour</p>


     */
    private double otherRunningCost;
    private double landingCosts;
    public SetOfVessels setOfVessels;
    public Metier possibleMetiers;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(EffortDescription.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(EffortDescription.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "fishingOperation", int.class, fishingOperation);
        visitor.visit(this, "fishingOperationDuration", TimeUnit.class, fishingOperationDuration);
        visitor.visit(this, "gearsNumberPerOperation", int.class, gearsNumberPerOperation);
        visitor.visit(this, "crewSize", int.class, crewSize);
        visitor.visit(this, "unitCostOfFishing", double.class, unitCostOfFishing);
        visitor.visit(this, "fixedCrewSalary", double.class, fixedCrewSalary);
        visitor.visit(this, "crewShareRate", double.class, crewShareRate);
        visitor.visit(this, "crewFoodCost", double.class, crewFoodCost);
        visitor.visit(this, "repairAndMaintenanceGearCost", double.class, repairAndMaintenanceGearCost);
        visitor.visit(this, "otherRunningCost", double.class, otherRunningCost);
        visitor.visit(this, "landingCosts", double.class, landingCosts);
        visitor.visit(this, "setOfVessels", SetOfVessels.class, setOfVessels);
        visitor.visit(this, "possibleMetiers", Metier.class, possibleMetiers);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setFishingOperation :
     * @param value 
     */

    public void setFishingOperation(int value) {
        int _oldValue = this.fishingOperation;
        fireOnPreWrite("fishingOperation", _oldValue, value);
        this.fishingOperation = value;
        fireOnPostWrite("fishingOperation", _oldValue, value);
}

    /**
     * getFishingOperation :
     * @return int 
     */

    public int getFishingOperation() {
        fireOnPreRead("fishingOperation", fishingOperation);
        int result = this.fishingOperation;
        fireOnPostRead("fishingOperation", fishingOperation);
        return result;
}

    /**
     * setFishingOperationDuration :
     * @param value 
     */

    public void setFishingOperationDuration(TimeUnit value) {
        TimeUnit _oldValue = this.fishingOperationDuration;
        fireOnPreWrite("fishingOperationDuration", _oldValue, value);
        this.fishingOperationDuration = value;
        fireOnPostWrite("fishingOperationDuration", _oldValue, value);
}

    /**
     * getFishingOperationDuration :
     * @return TimeUnit 
     */

    public TimeUnit getFishingOperationDuration() {
        fireOnPreRead("fishingOperationDuration", fishingOperationDuration);
        TimeUnit result = this.fishingOperationDuration;
        fireOnPostRead("fishingOperationDuration", fishingOperationDuration);
        return result;
}

    /**
     * setGearsNumberPerOperation :
     * @param value 
     */

    public void setGearsNumberPerOperation(int value) {
        int _oldValue = this.gearsNumberPerOperation;
        fireOnPreWrite("gearsNumberPerOperation", _oldValue, value);
        this.gearsNumberPerOperation = value;
        fireOnPostWrite("gearsNumberPerOperation", _oldValue, value);
}

    /**
     * getGearsNumberPerOperation :
     * @return int 
     */

    public int getGearsNumberPerOperation() {
        fireOnPreRead("gearsNumberPerOperation", gearsNumberPerOperation);
        int result = this.gearsNumberPerOperation;
        fireOnPostRead("gearsNumberPerOperation", gearsNumberPerOperation);
        return result;
}

    /**
     * setCrewSize :
     * @param value 
     */

    public void setCrewSize(int value) {
        int _oldValue = this.crewSize;
        fireOnPreWrite("crewSize", _oldValue, value);
        this.crewSize = value;
        fireOnPostWrite("crewSize", _oldValue, value);
}

    /**
     * getCrewSize :
     * @return int 
     */

    public int getCrewSize() {
        fireOnPreRead("crewSize", crewSize);
        int result = this.crewSize;
        fireOnPostRead("crewSize", crewSize);
        return result;
}

    /**
     * setUnitCostOfFishing :
     * @param value 
     */

    public void setUnitCostOfFishing(double value) {
        double _oldValue = this.unitCostOfFishing;
        fireOnPreWrite("unitCostOfFishing", _oldValue, value);
        this.unitCostOfFishing = value;
        fireOnPostWrite("unitCostOfFishing", _oldValue, value);
}

    /**
     * getUnitCostOfFishing :
     * @return double 
     */

    public double getUnitCostOfFishing() {
        fireOnPreRead("unitCostOfFishing", unitCostOfFishing);
        double result = this.unitCostOfFishing;
        fireOnPostRead("unitCostOfFishing", unitCostOfFishing);
        return result;
}

    /**
     * setFixedCrewSalary :
     * @param value 
     */

    public void setFixedCrewSalary(double value) {
        double _oldValue = this.fixedCrewSalary;
        fireOnPreWrite("fixedCrewSalary", _oldValue, value);
        this.fixedCrewSalary = value;
        fireOnPostWrite("fixedCrewSalary", _oldValue, value);
}

    /**
     * getFixedCrewSalary :
     * @return double 
     */

    public double getFixedCrewSalary() {
        fireOnPreRead("fixedCrewSalary", fixedCrewSalary);
        double result = this.fixedCrewSalary;
        fireOnPostRead("fixedCrewSalary", fixedCrewSalary);
        return result;
}

    /**
     * setCrewShareRate :
     * @param value 
     */

    public void setCrewShareRate(double value) {
        double _oldValue = this.crewShareRate;
        fireOnPreWrite("crewShareRate", _oldValue, value);
        this.crewShareRate = value;
        fireOnPostWrite("crewShareRate", _oldValue, value);
}

    /**
     * getCrewShareRate :
     * @return double 
     */

    public double getCrewShareRate() {
        fireOnPreRead("crewShareRate", crewShareRate);
        double result = this.crewShareRate;
        fireOnPostRead("crewShareRate", crewShareRate);
        return result;
}

    /**
     * setCrewFoodCost :
     * @param value 
     */

    public void setCrewFoodCost(double value) {
        double _oldValue = this.crewFoodCost;
        fireOnPreWrite("crewFoodCost", _oldValue, value);
        this.crewFoodCost = value;
        fireOnPostWrite("crewFoodCost", _oldValue, value);
}

    /**
     * getCrewFoodCost :
     * @return double 
     */

    public double getCrewFoodCost() {
        fireOnPreRead("crewFoodCost", crewFoodCost);
        double result = this.crewFoodCost;
        fireOnPostRead("crewFoodCost", crewFoodCost);
        return result;
}

    /**
     * setRepairAndMaintenanceGearCost :
     * @param value 
     */

    public void setRepairAndMaintenanceGearCost(double value) {
        double _oldValue = this.repairAndMaintenanceGearCost;
        fireOnPreWrite("repairAndMaintenanceGearCost", _oldValue, value);
        this.repairAndMaintenanceGearCost = value;
        fireOnPostWrite("repairAndMaintenanceGearCost", _oldValue, value);
}

    /**
     * getRepairAndMaintenanceGearCost :
     * @return double 
     */

    public double getRepairAndMaintenanceGearCost() {
        fireOnPreRead("repairAndMaintenanceGearCost", repairAndMaintenanceGearCost);
        double result = this.repairAndMaintenanceGearCost;
        fireOnPostRead("repairAndMaintenanceGearCost", repairAndMaintenanceGearCost);
        return result;
}

    /**
     * setOtherRunningCost :
     * @param value 
     */

    public void setOtherRunningCost(double value) {
        double _oldValue = this.otherRunningCost;
        fireOnPreWrite("otherRunningCost", _oldValue, value);
        this.otherRunningCost = value;
        fireOnPostWrite("otherRunningCost", _oldValue, value);
}

    /**
     * getOtherRunningCost :
     * @return double 
     */

    public double getOtherRunningCost() {
        fireOnPreRead("otherRunningCost", otherRunningCost);
        double result = this.otherRunningCost;
        fireOnPostRead("otherRunningCost", otherRunningCost);
        return result;
}

    /**
     * setLandingCosts :
     * @param value 
     */

    public void setLandingCosts(double value) {
        double _oldValue = this.landingCosts;
        fireOnPreWrite("landingCosts", _oldValue, value);
        this.landingCosts = value;
        fireOnPostWrite("landingCosts", _oldValue, value);
}

    /**
     * getLandingCosts :
     * @return double 
     */

    public double getLandingCosts() {
        fireOnPreRead("landingCosts", landingCosts);
        double result = this.landingCosts;
        fireOnPostRead("landingCosts", landingCosts);
        return result;
}

    /**
     * setSetOfVessels :
     * @param value La valeur de l'attribut setOfVessels à positionner.
     */

    public void setSetOfVessels(SetOfVessels value) {
        SetOfVessels _oldValue = this.setOfVessels;
        fireOnPreWrite("setOfVessels", _oldValue, value);
        this.setOfVessels = value;
        fireOnPostWrite("setOfVessels", _oldValue, value);
}

    /**
     * getSetOfVessels :
     * @return SetOfVessels 
     */

    public SetOfVessels getSetOfVessels() {    
        return setOfVessels;
}

    /**
     * setPossibleMetiers :
     * @param value La valeur de l'attribut possibleMetiers à positionner.
     */

    public void setPossibleMetiers(Metier value) {
        Metier _oldValue = this.possibleMetiers;
        fireOnPreWrite("possibleMetiers", _oldValue, value);
        this.possibleMetiers = value;
        fireOnPostWrite("possibleMetiers", _oldValue, value);
}

    /**
     * getPossibleMetiers :
     * @return Metier 
     */

    public Metier getPossibleMetiers() {    
        return possibleMetiers;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("fishingOperation", this.fishingOperation).
            append("fishingOperationDuration", this.fishingOperationDuration).
            append("gearsNumberPerOperation", this.gearsNumberPerOperation).
            append("crewSize", this.crewSize).
            append("unitCostOfFishing", this.unitCostOfFishing).
            append("fixedCrewSalary", this.fixedCrewSalary).
            append("crewShareRate", this.crewShareRate).
            append("crewFoodCost", this.crewFoodCost).
            append("repairAndMaintenanceGearCost", this.repairAndMaintenanceGearCost).
            append("otherRunningCost", this.otherRunningCost).
            append("landingCosts", this.landingCosts).
         toString();
        return result;
}


} //EffortDescriptionAbstract
