package fr.ifremer.isisfish.entities;

import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class CellDAOAbstract<E extends Cell> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Cell.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        {
            List<fr.ifremer.isisfish.entities.Zone> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from zone main, cell_zone secondary " +
                    "where main.topiaid=secondary.zone" +
                    " and secondary.cell='" + entity.getTopiaId() + "'")
                    .addEntity("main", fr.ifremer.isisfish.IsisFishDAOHelper.getImplementationClass(fr.ifremer.isisfish.entities.Zone.class)).list();
            for (fr.ifremer.isisfish.entities.Zone item : list) {
                item.removeCell(entity);
            }
        }

                {
                List<fr.ifremer.isisfish.entities.Port> list = getContext()
                            .getDAO(fr.ifremer.isisfish.entities.Port.class)
                            .findAllByProperties("cell", entity);
                    for (fr.ifremer.isisfish.entities.Port item : list) {
                        item.setCell(null);

                    }
                }

        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty("name", v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty("name", v);
        return result;
    }

    /**
     * findByLatitude :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut latitude le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByLatitude(float v) throws TopiaException {
        E result = findByProperty("latitude", v);
        return result;
    }

    /**
     * findAllByLatitude :
     * Retourne les éléments ayant comme valeur pour l'attribut latitude le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByLatitude(float v) throws TopiaException {
        List<E> result = findAllByProperty("latitude", v);
        return result;
    }

    /**
     * findByLongitude :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut longitude le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByLongitude(float v) throws TopiaException {
        E result = findByProperty("longitude", v);
        return result;
    }

    /**
     * findAllByLongitude :
     * Retourne les éléments ayant comme valeur pour l'attribut longitude le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByLongitude(float v) throws TopiaException {
        List<E> result = findAllByProperty("longitude", v);
        return result;
    }

    /**
     * findByLand :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut land le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByLand(boolean v) throws TopiaException {
        E result = findByProperty("land", v);
        return result;
    }

    /**
     * findAllByLand :
     * Retourne les éléments ayant comme valeur pour l'attribut land le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByLand(boolean v) throws TopiaException {
        List<E> result = findAllByProperty("land", v);
        return result;
    }

    /**
     * findByComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty("comment", v);
        return result;
    }

    /**
     * findAllByComment :
     * Retourne les éléments ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty("comment", v);
        return result;
    }


} //CellDAOAbstract<E extends Cell>
