package fr.ifremer.isisfish.entities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class CellAbstract extends TopiaEntityAbstract implements Cell {

    private String name;
    private float latitude;
    private float longitude;
    private boolean land;
    private String comment;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Cell.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Cell.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "name", String.class, name);
        visitor.visit(this, "latitude", float.class, latitude);
        visitor.visit(this, "longitude", float.class, longitude);
        visitor.visit(this, "land", boolean.class, land);
        visitor.visit(this, "comment", String.class, comment);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        fireOnPostWrite("name", _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead("name", name);
        String result = this.name;
        fireOnPostRead("name", name);
        return result;
}

    /**
     * setLatitude :
     * @param value 
     */

    public void setLatitude(float value) {
        float _oldValue = this.latitude;
        fireOnPreWrite("latitude", _oldValue, value);
        this.latitude = value;
        fireOnPostWrite("latitude", _oldValue, value);
}

    /**
     * getLatitude :
     * @return float 
     */

    public float getLatitude() {
        fireOnPreRead("latitude", latitude);
        float result = this.latitude;
        fireOnPostRead("latitude", latitude);
        return result;
}

    /**
     * setLongitude :
     * @param value 
     */

    public void setLongitude(float value) {
        float _oldValue = this.longitude;
        fireOnPreWrite("longitude", _oldValue, value);
        this.longitude = value;
        fireOnPostWrite("longitude", _oldValue, value);
}

    /**
     * getLongitude :
     * @return float 
     */

    public float getLongitude() {
        fireOnPreRead("longitude", longitude);
        float result = this.longitude;
        fireOnPostRead("longitude", longitude);
        return result;
}

    /**
     * setLand :
     * @param value 
     */

    public void setLand(boolean value) {
        boolean _oldValue = this.land;
        fireOnPreWrite("land", _oldValue, value);
        this.land = value;
        fireOnPostWrite("land", _oldValue, value);
}

    /**
     * getLand :
     * @return boolean 
     */

    public boolean getLand() {
        fireOnPreRead("land", land);
        boolean result = this.land;
        fireOnPostRead("land", land);
        return result;
}

    /**
     * setComment :
     * @param value 
     */

    public void setComment(String value) {
        String _oldValue = this.comment;
        fireOnPreWrite("comment", _oldValue, value);
        this.comment = value;
        fireOnPostWrite("comment", _oldValue, value);
}

    /**
     * getComment :
     * @return String 
     */

    public String getComment() {
        fireOnPreRead("comment", comment);
        String result = this.comment;
        fireOnPostRead("comment", comment);
        return result;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
            append("latitude", this.latitude).
            append("longitude", this.longitude).
            append("land", this.land).
            append("comment", this.comment).
         toString();
        return result;
}


} //CellAbstract
