package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.Date;
import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class ActiveRuleDAOAbstract<E extends ActiveRule> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)ActiveRule.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByActiveRuleDate :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut activeRuleDate le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByActiveRuleDate(Date v) throws TopiaException {
        E result = findByProperty("activeRuleDate", v);
        return result;
    }

    /**
     * findAllByActiveRuleDate :
     * Retourne les éléments ayant comme valeur pour l'attribut activeRuleDate le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByActiveRuleDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty("activeRuleDate", v);
        return result;
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty("name", v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty("name", v);
        return result;
    }

    /**
     * findByParam :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut param le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByParam(String v) throws TopiaException {
        E result = findByProperty("param", v);
        return result;
    }

    /**
     * findAllByParam :
     * Retourne les éléments ayant comme valeur pour l'attribut param le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByParam(String v) throws TopiaException {
        List<E> result = findAllByProperty("param", v);
        return result;
    }


} //ActiveRuleDAOAbstract<E extends ActiveRule>
