package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.Date;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class ActiveRuleAbstract extends TopiaEntityAbstract implements ActiveRule {

    private Date activeRuleDate;
    private String name;
    private String param;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(ActiveRule.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(ActiveRule.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "activeRuleDate", Date.class, activeRuleDate);
        visitor.visit(this, "name", String.class, name);
        visitor.visit(this, "param", String.class, param);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setActiveRuleDate :
     * @param value 
     */

    public void setActiveRuleDate(Date value) {
        Date _oldValue = this.activeRuleDate;
        fireOnPreWrite("activeRuleDate", _oldValue, value);
        this.activeRuleDate = value;
        fireOnPostWrite("activeRuleDate", _oldValue, value);
}

    /**
     * getActiveRuleDate :
     * @return Date 
     */

    public Date getActiveRuleDate() {
        fireOnPreRead("activeRuleDate", activeRuleDate);
        Date result = this.activeRuleDate;
        fireOnPostRead("activeRuleDate", activeRuleDate);
        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        fireOnPostWrite("name", _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead("name", name);
        String result = this.name;
        fireOnPostRead("name", name);
        return result;
}

    /**
     * setParam :
     * @param value 
     */

    public void setParam(String value) {
        String _oldValue = this.param;
        fireOnPreWrite("param", _oldValue, value);
        this.param = value;
        fireOnPostWrite("param", _oldValue, value);
}

    /**
     * getParam :
     * @return String 
     */

    public String getParam() {
        fireOnPreRead("param", param);
        String result = this.param;
        fireOnPostRead("param", param);
        return result;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("activeRuleDate", this.activeRuleDate).
            append("name", this.name).
            append("param", this.param).
         toString();
        return result;
}


} //ActiveRuleAbstract
