/* *##%
 * Copyright (C) 2009-2010 Ifremer, Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package fr.ifremer.isisfish.datastore;

import java.io.File;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.util.Docable;
import fr.ifremer.isisfish.vcs.VCSException;

/**
 * Gestion des fichers VCS de type {@link SensitivityExport}
 * (appartenant au module exports).
 *
 * Created: 18 août 2005 15:07:36 CEST
 *
 * @author chatellier eric <chatellier@codelutin.com>
 * @version $Revision: 2938 $
 *
 * Last update: $Date: 2010-01-22 16:42:09 +0100 (ven., 22 janv. 2010) $
 * by : $Author: chatellier $
 */
public class SensitivityExportStorage extends ExportStorage implements Docable {

    /** Class logger. */
    private static Log log = LogFactory.getLog(SensitivityExportStorage.class);

    public static final String SENSITIVITY_EXPORT_PATH = "sensitivityexports";

    /** Template freemarker pour les scripts d'export . */
    public static final String SENSITIVITY_EXPORT_TEMPLATE = "templates/script/sensitivityexport.ftl";

    @SuppressWarnings("unchecked")
    private static Map<String, SensitivityExportStorage> sensitivityExportsCache = (Map<String, SensitivityExportStorage>) new ReferenceMap();

    /**
     * Constructeur.
     *
     * @param rootSrc   le repertoire root de stockage des exports
     * @param directory le repertoire de l'export
     * @param name      le nom de l'export
     */
    protected SensitivityExportStorage(File rootSrc, File directory, String name) {
        super(rootSrc, directory, name);
    }

    public static File getSensitivityExportDirectory() {
        File result = new File(getContextDatabaseDirectory(), SENSITIVITY_EXPORT_PATH);
        result.mkdirs();
        return result;
    }

    /**
     * Retourne une nouvelle instance de l'export. Compile le fichier si besoin.
     *
     * @return une nouvelle instance de la classe d'export
     * @throws IsisFishException
     */
    public SensitivityExport getNewSensitivityExportInstance() throws IsisFishException {
        Object result = getNewInstance();
        return (SensitivityExport) result;
    }

    /**
     * Retourne le storage pour l'export demandé.
     *
     * @param name le nom de la regle souhaitée
     * @return Le storage pour la regle
     */
    public static SensitivityExportStorage getSensitivityExport(String name) {
        String cacheName = getContextDatabaseCacheKey(name);
        SensitivityExportStorage result = sensitivityExportsCache.get(cacheName);
        if (result == null) {
            result = new SensitivityExportStorage(getContextDatabaseDirectory(),
                    getSensitivityExportDirectory(), name);
            sensitivityExportsCache.put(cacheName, result);
        }
        return result;
    }

    /**
     * Retourne la liste des noms de toutes les régions disponible en local.
     *
     * @return la liste des noms de toutes les régions disponible en local
     */
    public static List<String> getSensitivityExportNames() {
        File dir = getSensitivityExportDirectory();
        return getStorageNames(dir);
    }

    public static void checkout() throws VCSException {
        checkout(IsisFish.config.getDatabaseDirectory(), SENSITIVITY_EXPORT_PATH);
    }
}
