/* *##%
 *  Copyright (C) 2002-2009 Ifremer, Code Lutin, Benjamin Poussin
 * 
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 *##%*/

package fr.ifremer.isisfish.actions;

import java.io.File;
import java.util.Arrays;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.KeyPair;

import fr.ifremer.isisfish.IsisConfig;

/**
 * VCS actions.
 * 
 * @author poussin
 * @version $Revision: 1862 $
 *
 * Last update: $Date: 2009-02-23 16:42:34 +0100 (lun. 23 févr. 2009) $
 * by : $Author: chatellier $
 */
public class VCSAction {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(VCSAction.class);

    protected IsisConfig config = null;

    public VCSAction(IsisConfig config) {
        this.config = config;
    }

    public void sshCreateKey(boolean force) throws Exception {
        File f = config.getSSHPrivateKeyFilePath();

        // check already exist key
        if (f.exists() && !force) {
            log.error("the private key already exist " + f + ", use option [force] to overwrite");
            return;
        }

        // bug #1623, le dossier parent n'existe pas
        if (f.getParentFile() != null && !f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }

        if (log.isInfoEnabled()) {
            log.info("Generate ssh key to " + f);
        }
        JSch jsch=new JSch();
        KeyPair kpair=KeyPair.genKeyPair(jsch, KeyPair.RSA, 2048);
        //kpair.setPassphrase(passphrase);
        kpair.writePrivateKey(f.getAbsolutePath());
        kpair.writePublicKey(f.getAbsolutePath()+".pub", config.getUserName() + "@forIsisFish");
        if (log.isInfoEnabled()) {
            log.info("Finger print: "+kpair.getFingerPrint());
        }
        kpair.dispose();
    }

    public void vcsUpdate() throws Exception {
        // ATTENTION: il est inutile de d'accepter cette option au premier
        // lancement! car on a effectue soit un checkout, soit
        // une migration
        // !IsisContext.get().isFirstLaunch()
        // Welcome.updateVCS(null);
    }

    public void vcsAdd(File ... file) throws Exception {
        log.info("file*:" + Arrays.toString(file));
        throw new UnsupportedOperationException("to be done...");
    }

    public void vcsRemove(File ... file) throws Exception {
        log.info("file*:" + Arrays.toString(file));
        throw new UnsupportedOperationException("to be done...");
    }

    public void vcsCommit(File ... file) throws Exception {
        log.info("file*:" + Arrays.toString(file));
        throw new UnsupportedOperationException("to be done...");
    }

}
