package fr.ifremer.echobase.ui.actions.spatial;

/*
 * #%L
 * EchoBase :: UI
 * $Id: GetVoyageDataMetadata.java 842 2013-08-15 10:53:16Z tchemit $
 * $HeadURL: https://forge.codelutin.com/svn/echobase/tags/echobase-2.5/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/spatial/GetVoyageDataMetadata.java $
 * %%
 * Copyright (C) 2011 - 2013 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.entities.references.DataMetadata;
import fr.ifremer.echobase.services.service.spatial.SpatialService;

import java.util.Map;

/**
 * Obtain all dataMetadata used for a given voyage.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.2
 */
public class GetVoyageDataMetadata extends AbstractGetVoyage {

    private static final long serialVersionUID = 1L;

    @Override
    public Map<String, String> getData() {
        return data;
    }

    @Override
    protected Map<String, String> buildData(SpatialService service,
                                            Voyage voyage) {
        Map<String, String> result = workingDbPersistenceService.loadSortAndDecorate(DataMetadata.class);
        return result;
    }
}