/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.spatial;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.services.service.WorkingDbPersistenceService;
import fr.ifremer.echobase.services.service.spatial.SpatialService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractGetVoyage
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    protected String voyageId;
    protected Map<String, String> data;
    protected transient WorkingDbPersistenceService workingDbPersistenceService;
    protected transient SpatialService spatialService;

    public void setVoyageId(String voyageId) {
        this.voyageId = voyageId;
    }

    protected abstract Map<String, String> buildData(SpatialService var1, Voyage var2);

    public abstract Map<String, String> getData();

    public String execute() throws Exception {
        if (StringUtils.isEmpty((CharSequence)this.voyageId)) {
            this.data = Maps.newLinkedHashMap();
        } else {
            Voyage voyage = this.workingDbPersistenceService.getVoyage(this.voyageId);
            Preconditions.checkNotNull((Object)voyage, (Object)("Could not find voyage with id " + this.voyageId));
            this.data = this.buildData(this.spatialService, voyage);
        }
        return "success";
    }

    public void setWorkingDbPersistenceService(WorkingDbPersistenceService workingDbPersistenceService) {
        this.workingDbPersistenceService = workingDbPersistenceService;
    }

    public void setSpatialService(SpatialService spatialService) {
        this.spatialService = spatialService;
    }
}

