package fr.ifremer.echobase.ui.actions.workingDb;

/*
 * #%L
 * EchoBase :: UI
 * $Id: GetVoyage.java 842 2013-08-15 10:53:16Z tchemit $
 * $HeadURL: https://forge.codelutin.com/svn/echobase/tags/echobase-2.3/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/workingDb/GetVoyage.java $
 * %%
 * Copyright (C) 2011 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.echobase.entities.EchoBaseEntityEnum;
import fr.ifremer.echobase.entities.ImportLog;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.entities.references.AreaOfOperation;
import fr.ifremer.echobase.entities.references.Mission;
import fr.ifremer.echobase.services.service.DbEditorService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.nuiton.topia.persistence.metadata.TableMeta;

import java.util.Map;

/**
 * Obtain details of a given {@link ImportLog}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class GetVoyage extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    protected String voyageId;

    public void setVoyageId(String voyageId) {
        this.voyageId = voyageId;
    }

    protected Map data;

    public Map<?, ?> getData() {
        return data;
    }

    @Override
    public String execute() throws Exception {

        TableMeta<EchoBaseEntityEnum> tableMeta =
                dbEditorService.getTableMeta(EchoBaseEntityEnum.Voyage);
        data = dbEditorService.getData(tableMeta, voyageId);

        // decorate foreign keys
        dbEditorService.decorateForeignKey(data, Mission.class, Voyage.PROPERTY_MISSION, null);
        dbEditorService.decorateForeignKey(data, AreaOfOperation.class, Voyage.PROPERTY_AREA_OF_OPERATION, null);

        return SUCCESS;
    }

    //------------------------------------------------------------------------//
    //-- Injected objects                                                     //
    //------------------------------------------------------------------------//

    protected transient DbEditorService dbEditorService;

    public void setDbEditorService(DbEditorService dbEditorService) {
        this.dbEditorService = dbEditorService;
    }

}