<%--
  #%L
  EchoBase :: UI
  
  $Id: exportSql.jsp 104 2011-11-21 16:12:09Z sletellier $
  $HeadURL: http://svn.forge.codelutin.com/svn/echobase/trunk/echobase-ui/src/main/webapp/WEB-INF/jsp/export/exportSql.jsp $
  %%
  Copyright (C) 2011 Ifremer, Codelutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>

<s:url id="reloadUrl" action='exportSql' namespace='/export'/>
<s:url id="exportSqlResultUrl" action="exportSqlResult" namespace="/export"/>
<s:set var="noError" value="!hasErrors()"/>
<script type="text/javascript">

  function reloadQuery() {
    var queryId = $('[name="query.topiaId"]').val();
    var url = "${reloadUrl}?" + $.param({ 'query.topiaId':queryId});
    window.location = url;
    return false;
  }

  function loadGridData() {
    // get sql query
    var sqlQuery = "${exportSqlResultUrl}?" +
                   $.param({ sql :$('[name="query.sqlQuery"]').val()});

    $.ajax(sqlQuery, {
      success: function(data, textStatus, jqXHR) {
        $('#resultGrid').html(data);
      }
    });
    return false;
  }

  jQuery(document).ready(function () {

    $('[name="query.topiaId"]').change(function(event) {
      var url = "${reloadUrl}?" + $.param({ 'query.topiaId':this.value});
      window.location = url;
    });

    var queryId = $('[name="query.topiaId"]').val();
    if (queryId && ${noError}) {
      // auto launch query
      loadGridData();
    }

  });


</script>

<title><s:text name="echobase.title.export"/></title>

<s:set var="queryExists" value="query.topiaId != null && query.topiaId != ''"/>

<s:form id="exportQueryForm" namespace="/export">

  <s:select key="query.topiaId" label="%{getText('echobase.label.sqlQueries')}"
            list="queries" headerKey="" headerValue=""/>

  <br/>

  <fieldset>
    <legend><s:text name="echobase.legend.sqlQuery.configuration"/></legend>

    <s:textarea key="query.name" required="true" cols="160" rows="1"
                label="%{getText('echobase.label.query.name')}"/>

    <s:textarea key="query.description" required="true" cols="160" rows="2"
                label="%{getText('echobase.label.query.description')}"/>

    <s:textarea key="query.sqlQuery" required="true" cols="160" rows="4"
                label="%{getText('echobase.label.query.sql')}"/>

    <s:if test="queryExists">

      <s:label value="%{query.lastModifiedDate}" readonly="true"
               label="%{getText('echobase.common.lastModifiedDate')}"/>

      <s:label value="%{decorate(query.lastModifiedUser, null)}" readonly="true"
               label="%{getText('echobase.common.lastModifiedUser')}"/>

    </s:if>


    <ul class="toolbar floatRight">
      <s:if test="queryExists">
        <li>
          <s:submit onclick="return reloadQuery();" theme="simple"
                    key="echobase.action.reloadSqlQuery"/>
        </li>
        <li>
          <s:submit action="cloneExportQuery" theme="simple"
                    key="echobase.action.cloneSqlQuery"/>
        </li>
        <li>
          <s:submit action="deleteExportQuery" theme="simple"
                    key="echobase.action.deleteSqlQuery"/>
        </li>
      </s:if>
      <li>
        <s:submit action="saveExportQuery" theme="simple"
                  key="echobase.action.saveSqlQuery"/>
      </li>
      <li>
        <s:submit key="echobase.action.applySqlQuery" theme="simple"
                  onclick="return loadGridData();"/>
      </li>
    </ul>
  </fieldset>
</s:form>

<br/>

<div id="resultGrid" class="cleanBoth"></div>


