/*
 * #%L
 * $Id: CommonFacade.java 543 2011-01-23 21:03:33Z chatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/coser/tags/coser-1.4.2/coser-web/src/main/java/fr/ifremer/coser/web/actions/common/CommonFacade.java $
 * %%
 * Copyright (C) 2010 - 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.coser.web.actions.common;

import java.util.Map;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;

/**
 * Facade list action.
 * 
 * @author chatellier
 * @version $Revision: 543 $
 * 
 * Last update : $Date: 2011-01-23 22:03:33 +0100 (Sun, 23 Jan 2011) $
 * By : $Author: chatellier $
 */
public abstract class CommonFacade extends CoserAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3385467755357775199L;

    protected Map<String, String> facades;

    public Map<String, String> getFacades() {
        return facades;
    }

    @Override
    public String execute() {

        WebService webService = ServiceFactory.getWebService();
        try {
            // renvoi la liste des facadeid et leur label associé
            facades = webService.getFacades();

        } catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get facades", ex);
        }

        return SUCCESS;
    }
}
