/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.validators;

import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.validators.ExpressionValidator;

public class CoserExpressionValidator
extends ExpressionValidator {
    private ValueStack localStack;

    public void setValueStack(ValueStack localStack) {
        super.setValueStack(localStack);
        this.localStack = localStack;
    }

    public void validate(Object object) throws ValidationException {
        Boolean answer = Boolean.FALSE;
        Object obj = null;
        try {
            obj = this.getFieldValue(this.getExpression(), object, true);
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            obj = Boolean.TRUE;
        }
        if (obj != null && obj instanceof Boolean) {
            answer = (Boolean)obj;
        } else {
            this.log.warn("Got result of " + obj + " when trying to get Boolean.", new String[0]);
        }
        if (!answer.booleanValue()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Validation failed on expression " + this.getExpression() + " with validated object " + object, new String[0]);
            }
            this.addActionError(object);
        }
    }

    protected Object getFieldValue(String name, Object object, boolean throwExceptionOnFailure) throws ValidationException {
        boolean pop = false;
        if (!this.localStack.getRoot().contains(object)) {
            this.localStack.push(object);
            pop = true;
        }
        Object retVal = this.localStack.findValue(name, throwExceptionOnFailure);
        if (pop) {
            this.localStack.pop();
        }
        return retVal;
    }
}

