/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.validators;

import com.opensymphony.xwork2.validator.ValidationException;
import fr.ifremer.coser.validators.AbstractFieldValidator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class CoserCheckDoubleValidator
extends AbstractFieldValidator {
    protected static final Pattern DOUBLE_PATTERN = Pattern.compile("^-?[0-9]+(\\.([0-9]+))?([eE](\\-?[0-9]+))?$");
    protected String notAvailable;
    protected Integer minDecimals;

    public String getNotAvailable() {
        return this.notAvailable;
    }

    public void setNotAvailable(String notAvailable) {
        this.notAvailable = notAvailable;
    }

    public Integer getMinDecimals() {
        return this.minDecimals;
    }

    public void setMinDecimals(Integer minDecimals) {
        this.minDecimals = minDecimals;
    }

    public void validate(Object object) throws ValidationException {
        Object obj = this.getFieldValue(this.getFieldName(), object);
        String value = (String)obj;
        if (value == null || value.isEmpty()) {
            return;
        }
        if (this.notAvailable != null && this.notAvailable.equals(value)) {
            return;
        }
        if (this.minDecimals != null) {
            Matcher matcher = DOUBLE_PATTERN.matcher(value);
            if (matcher.find()) {
                int decimaleSize = StringUtils.length((CharSequence)matcher.group(2));
                int exposant = 0;
                if (matcher.group(4) != null) {
                    exposant = Integer.parseInt(matcher.group(4));
                }
                if (decimaleSize - exposant < this.minDecimals) {
                    this.addFieldError(this.getFieldName(), object);
                }
            } else {
                this.addFieldError(this.getFieldName(), object);
            }
        }
        try {
            Double.parseDouble(value);
        }
        catch (NumberFormatException ex) {
            this.addFieldError(this.getFieldName(), object);
        }
    }
}

