/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.services;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.FileManagerFactory;
import com.opensymphony.xwork2.ValidationAwareSupport;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationManager;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.ValueStackFactory;
import com.opensymphony.xwork2.validator.ActionValidatorManager;
import com.opensymphony.xwork2.validator.DelegatingValidatorContext;
import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.ValidatorContext;
import fr.ifremer.coser.CoserBusinessConfig;
import fr.ifremer.coser.CoserConstants;
import fr.ifremer.coser.bean.Control;
import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.control.ControlError;
import fr.ifremer.coser.control.DiffCatchLengthControlError;
import fr.ifremer.coser.control.SpeciesControlError;
import fr.ifremer.coser.control.SpeciesLengthControlError;
import fr.ifremer.coser.data.AbstractDataEntity;
import fr.ifremer.coser.data.Catch;
import fr.ifremer.coser.data.Haul;
import fr.ifremer.coser.data.Length;
import fr.ifremer.coser.data.Strata;
import fr.ifremer.coser.storage.DataStorage;
import fr.ifremer.coser.util.ProgressMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ControlService {
    private static final Log log = LogFactory.getLog(ControlService.class);
    protected CoserBusinessConfig config;
    protected ValidationAwareSupport validationSupport;
    protected DelegatingValidatorContext validationContext;
    protected ActionValidatorManager validator;
    protected ActionContext context;
    protected static final Pattern FISH_LENGTH_PATTERN = Pattern.compile("^\\d+(\\.[05]0*)?$");

    public ControlService(CoserBusinessConfig config) {
        this.config = config;
        this.validationSupport = new ValidationAwareSupport();
        this.validationContext = new DelegatingValidatorContext((Object)this.validationSupport);
        ConfigurationManager confManager = new ConfigurationManager();
        Configuration conf = confManager.getConfiguration();
        Container container = conf.getContainer();
        FileManagerFactory fileManagerFactory = (FileManagerFactory)container.getInstance(FileManagerFactory.class);
        fileManagerFactory.setReloadingConfigs("false");
        ValueStackFactory stackFactory = (ValueStackFactory)container.getInstance(ValueStackFactory.class);
        ValueStack vs = stackFactory.createValueStack();
        this.context = new ActionContext(vs.getContext());
        ActionContext.setContext((ActionContext)this.context);
        Container container2 = this.context.getContainer();
        this.validator = (ActionValidatorManager)container2.getInstance(ActionValidatorManager.class, "no-annotations");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ControlError> validate(AbstractDataEntity bean, CoserConstants.Category category) {
        ArrayList<ControlError> result = new ArrayList<ControlError>();
        try {
            ActionContext.setContext((ActionContext)this.context);
            for (CoserConstants.ValidationLevel validationLevel : CoserConstants.ValidationLevel.values()) {
                try {
                    this.validator.validate((Object)bean, validationLevel.getXWorkContext(), (ValidatorContext)this.validationContext);
                    if (!this.validationContext.hasErrors()) continue;
                    Map fieldErrors = this.validationContext.getFieldErrors();
                    for (List errors : fieldErrors.values()) {
                        ControlError error = new ControlError();
                        error.setCategory(category);
                        String messages = StringUtils.join((Iterable)errors, (String)", ");
                        error.setMessage(messages);
                        error.setLevel(validationLevel);
                        error.addLineNumber(bean.getLine());
                        result.add(error);
                    }
                    Collection actionMessages = this.validationContext.getActionErrors();
                    if (!CollectionUtils.isNotEmpty((Collection)actionMessages)) continue;
                    ControlError error = new ControlError();
                    error.setCategory(category);
                    String messages = StringUtils.join((Iterable)actionMessages, (String)", ");
                    error.setMessage(messages);
                    error.setLevel(validationLevel);
                    error.addLineNumber(bean.getLine());
                    result.add(error);
                }
                finally {
                    this.validationSupport.clearFieldErrors();
                    this.validationSupport.clearActionErrors();
                }
            }
        }
        catch (ValidationException ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't validate bean", (Throwable)ex);
            }
        }
        finally {
            this.validationSupport.clearFieldErrors();
            this.validationSupport.clearActionErrors();
        }
        return result;
    }

    public List<ControlError> validateData(Project project, Control control, ProgressMonitor progress) {
        if (progress != null) {
            progress.setStepCount(11);
            progress.setStep(0);
        }
        ArrayList<ControlError> validationErrors = new ArrayList<ControlError>();
        for (CoserConstants.Category category : CoserConstants.Category.values()) {
            List<ControlError> specificErrors;
            if (!category.isDataCategory()) continue;
            List<ControlError> categoryErrors = this.validateCategoryXWork(project, control, category, progress);
            if (categoryErrors != null) {
                validationErrors.addAll(categoryErrors);
            }
            if (progress != null) {
                progress.nextStep();
            }
            if ((specificErrors = this.validateCategorySpecific(project, control, category, progress)) != null) {
                validationErrors.addAll(specificErrors);
            }
            if (progress == null) continue;
            progress.nextStep();
        }
        List<? extends ControlError> diffCatchLengthErrors = this.validateDiffCatchLength(project, control, progress);
        if (progress != null) {
            progress.nextStep();
        }
        if (diffCatchLengthErrors != null) {
            validationErrors.addAll(diffCatchLengthErrors);
        }
        List<ControlError> crossFileErrors = this.validationCrossFiles(project, control, progress);
        if (progress != null) {
            progress.nextStep();
        }
        if (crossFileErrors != null) {
            validationErrors.addAll(crossFileErrors);
        }
        if (validationErrors.isEmpty()) {
            ControlError noErrorError = new ControlError();
            noErrorError.setLevel(CoserConstants.ValidationLevel.INFO);
            noErrorError.setMessage(I18n.t((String)"coser.business.control.noerrorfound", (Object[])new Object[0]));
            validationErrors.add(noErrorError);
        }
        return validationErrors;
    }

    public List<ControlError> validateCategoryXWork(Project project, Control control, CoserConstants.Category category, ProgressMonitor progress) {
        Catch beanCatch = new Catch();
        Haul beanHaul = new Haul();
        Length beanLength = new Length();
        Strata beanStrata = new Strata();
        DataStorage dataToCheck = null;
        switch (category) {
            case CATCH: {
                dataToCheck = control.getCatch();
                break;
            }
            case HAUL: {
                dataToCheck = control.getHaul();
                break;
            }
            case LENGTH: {
                dataToCheck = control.getLength();
                break;
            }
            case STRATA: {
                dataToCheck = control.getStrata();
            }
        }
        int total = dataToCheck.size() - 1;
        if (progress != null) {
            progress.setText(I18n.t((String)"coser.business.control.step.xworks", (Object[])new Object[]{I18n.t((String)category.getTranslationKey(), (Object[])new Object[0]), 0}));
            progress.setTotal(total);
        }
        HashMap<String, String> uniqueDataKeys = new HashMap<String, String>();
        HashMap<String, ControlError> uniqueDataErrors = new HashMap<String, ControlError>();
        ArrayList<ControlError> validationErrors = new ArrayList<ControlError>();
        Iterator<String[]> itDataToCheck = dataToCheck.iterator(true);
        int lineIndex = 1;
        while (itDataToCheck.hasNext()) {
            if (progress != null) {
                int progressPercent = (int)((double)lineIndex / (double)total * 100.0);
                progress.setText(I18n.t((String)"coser.business.control.step.xworks", (Object[])new Object[]{I18n.t((String)category.getTranslationKey(), (Object[])new Object[0]), progressPercent}));
                progress.setCurrent(lineIndex);
                ++lineIndex;
            }
            String[] line = itDataToCheck.next();
            List<ControlError> errors = null;
            switch (category) {
                case CATCH: {
                    beanCatch.setData(line);
                    errors = this.validate(beanCatch, category);
                    break;
                }
                case HAUL: {
                    beanHaul.setData(line);
                    errors = this.validate(beanHaul, category);
                    break;
                }
                case LENGTH: {
                    beanLength.setData(line);
                    errors = this.validate(beanLength, category);
                    break;
                }
                case STRATA: {
                    beanStrata.setData(line);
                    errors = this.validate(beanStrata, category);
                }
            }
            if (errors != null) {
                validationErrors.addAll(errors);
            }
            String lineNumber = line[0];
            String uniqueDataKey = this.getSignificantData(project, category, line);
            if (uniqueDataKeys.containsKey(uniqueDataKey)) {
                ControlError error = null;
                if (uniqueDataErrors.containsKey(uniqueDataKey)) {
                    error = (ControlError)uniqueDataErrors.get(uniqueDataKey);
                } else {
                    error = new ControlError();
                    error.setCategory(category);
                    error.setLevel(CoserConstants.ValidationLevel.ERROR);
                    error.addLineNumber((String)uniqueDataKeys.get(uniqueDataKey));
                    error.setMessage(I18n.t((String)"coser.business.control.error.duplicatedLine", (Object[])new Object[]{uniqueDataKey}));
                    error.setDetailMessage(I18n.t((String)"coser.business.control.error.duplicatedLineDetails", (Object[])new Object[]{uniqueDataKey}));
                    validationErrors.add(error);
                    uniqueDataErrors.put(uniqueDataKey, error);
                }
                error.addLineNumber(lineNumber);
                dataToCheck.indexOf(lineNumber);
                continue;
            }
            uniqueDataKeys.put(uniqueDataKey, lineNumber);
        }
        return validationErrors;
    }

    protected String getSignificantData(Project project, CoserConstants.Category category, String[] data) {
        StringBuilder sb = new StringBuilder();
        block6: for (int index = 0; index < data.length; ++index) {
            if (index == 0) continue;
            switch (category) {
                case CATCH: {
                    if (index == 1 || index == 2 || index == 3) {
                        sb.append(data[index]).append('|');
                        continue block6;
                    }
                    if (index != 4) continue block6;
                    sb.append(project.getDisplaySpeciesText(data[index])).append('|');
                    continue block6;
                }
                case HAUL: {
                    if (index != 1 && index != 2 && index != 3 && index != 4) continue block6;
                    sb.append(data[index]).append('|');
                    continue block6;
                }
                case LENGTH: {
                    if (index == 1 || index == 2 || index == 3 || index == 5 || index == 6 || index == 7) {
                        sb.append(data[index]).append('|');
                        continue block6;
                    }
                    if (index != 4) continue block6;
                    sb.append(project.getDisplaySpeciesText(data[index])).append('|');
                    continue block6;
                }
                case STRATA: {
                    if (index != 1 && index != 2) continue block6;
                    sb.append(data[index]).append('|');
                }
            }
        }
        return sb.toString();
    }

    protected List<ControlError> validateCategorySpecific(Project project, Control control, CoserConstants.Category category, ProgressMonitor progress) {
        List<ControlError> validationErrors = null;
        switch (category) {
            case CATCH: {
                validationErrors = this.validateCategorySpecificCatch(project, control, progress);
                break;
            }
            case HAUL: {
                validationErrors = this.validateCategorySpecificHaul(project, control, progress);
                break;
            }
            case LENGTH: {
                validationErrors = this.validateCategorySpecificLength(project, control, progress);
                break;
            }
            case STRATA: {
                validationErrors = this.validateCategorySpecificStrata(project, control, progress);
            }
        }
        return validationErrors;
    }

    protected List<ControlError> validateCategorySpecificCatch(Project project, Control control, ProgressMonitor progress) {
        ArrayList<ControlError> validationErrors = new ArrayList<ControlError>();
        int total = control.getCatch().size() - 1;
        if (progress != null) {
            progress.setText(I18n.t((String)"coser.business.control.step.observation", (Object[])new Object[]{I18n.t((String)CoserConstants.Category.CATCH.getTranslationKey(), (Object[])new Object[0]), 0}));
            progress.setTotal(total);
        }
        HashMap<String, Double> nombreForKey = new HashMap<String, Double>();
        HashMap<String, String> firstLineForKey = new HashMap<String, String>();
        Iterator<String[]> itTuple = control.getCatch().iterator(true);
        int lineIndex = 1;
        while (itTuple.hasNext()) {
            String[] tuple = itTuple.next();
            if (progress != null) {
                int progressPercent = (int)((double)lineIndex / (double)total * 100.0);
                progress.setText(I18n.t((String)"coser.business.control.step.observation", (Object[])new Object[]{I18n.t((String)CoserConstants.Category.CATCH.getTranslationKey(), (Object[])new Object[0]), progressPercent}));
                progress.setCurrent(lineIndex);
                ++lineIndex;
            }
            StringBuilder sb = new StringBuilder();
            for (int tupleIndex = 0; tupleIndex < tuple.length; ++tupleIndex) {
                if (tupleIndex == 2 || tupleIndex == 3) {
                    sb.append(tuple[tupleIndex]).append(';');
                    continue;
                }
                if (tupleIndex != 4) continue;
                sb.append(project.getDisplaySpeciesText(tuple[tupleIndex])).append(';');
            }
            String nombreValue = tuple[5];
            String lineNumber = tuple[0];
            try {
                Double nombre = Double.valueOf(nombreValue);
                String key = sb.toString();
                if (nombreForKey.containsKey(key)) {
                    Double oldValue = (Double)nombreForKey.get(key);
                    Double newValue = oldValue + nombre;
                    nombreForKey.put(key, newValue);
                    continue;
                }
                nombreForKey.put(key, nombre);
                firstLineForKey.put(key, lineNumber);
            }
            catch (NumberFormatException ex) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Can't parse '" + nombreValue + "' as double"));
            }
        }
        for (Map.Entry sumObservation : nombreForKey.entrySet()) {
            String key = (String)sumObservation.getKey();
            Double value = (Double)sumObservation.getValue();
            if (!(value < this.config.getControlNobsmin())) continue;
            String lineNumber = (String)firstLineForKey.get(key);
            ControlError error = new ControlError();
            error.setCategory(CoserConstants.Category.CATCH);
            error.setLevel(CoserConstants.ValidationLevel.WARNING);
            error.addLineNumber(lineNumber);
            error.setMessage(I18n.t((String)"coser.business.control.error.minObservationCount", (Object[])new Object[0]));
            error.setDetailMessage(I18n.t((String)"coser.business.control.error.minObservationCountDetail", (Object[])new Object[]{key, value}));
            validationErrors.add(error);
        }
        return validationErrors;
    }

    protected List<? extends ControlError> validateDiffCatchLength(Project project, Control control, ProgressMonitor progress) {
        int total = control.getCatch().size() - 1 + control.getLength().size() - 1;
        if (progress != null) {
            progress.setText(I18n.t((String)"coser.business.control.step.diffCatchLength", (Object[])new Object[]{0}));
            progress.setTotal(total);
        }
        ArrayList<SpeciesControlError> validationErrors = new ArrayList<SpeciesControlError>();
        TreeSet<String> setYear = new TreeSet<String>();
        HashSet<String> missingYearLengthSpecies = new HashSet<String>();
        HashMap catchForSpeciesYears = new HashMap();
        Iterator<String[]> itCatchData = control.getCatch().iterator(true);
        int lineIndex = 1;
        while (itCatchData.hasNext()) {
            String[] tuple;
            String species;
            HashMap<String, Double> speciesCatchForYears;
            if (progress != null) {
                int progressPercent = (int)((double)lineIndex / (double)total * 100.0);
                progress.setText(I18n.t((String)"coser.business.control.step.diffCatchLength", (Object[])new Object[]{progressPercent}));
                progress.setCurrent(lineIndex);
                ++lineIndex;
            }
            if ((speciesCatchForYears = (HashMap<String, Double>)catchForSpeciesYears.get(species = (tuple = itCatchData.next())[4])) == null) {
                speciesCatchForYears = new HashMap<String, Double>();
                catchForSpeciesYears.put(species, speciesCatchForYears);
            }
            String year = tuple[2];
            setYear.add(year);
            String nombreValue = tuple[5];
            try {
                Double nombreDouble = Double.valueOf(nombreValue);
                if (speciesCatchForYears.containsKey(year)) {
                    Double oldValue = (Double)speciesCatchForYears.get(year);
                    Double newValue = oldValue + nombreDouble;
                    speciesCatchForYears.put(year, newValue);
                    continue;
                }
                speciesCatchForYears.put(year, nombreDouble);
            }
            catch (NumberFormatException ex) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Can't parse " + nombreValue + " as double"));
            }
        }
        HashMap lengthForSpeciesYears = new HashMap();
        Iterator<String[]> itLengthData = control.getLength().iterator(true);
        while (itLengthData.hasNext()) {
            String[] tuple;
            String species;
            HashMap<String, Double> speciesLengthForYears;
            if (progress != null) {
                int progressPercent = (int)((double)lineIndex / (double)total * 100.0);
                progress.setText(I18n.t((String)"coser.business.control.step.diffCatchLength", (Object[])new Object[]{progressPercent}));
                progress.setCurrent(lineIndex);
                ++lineIndex;
            }
            if ((speciesLengthForYears = (HashMap<String, Double>)lengthForSpeciesYears.get(species = (tuple = itLengthData.next())[4])) == null) {
                speciesLengthForYears = new HashMap<String, Double>();
                lengthForSpeciesYears.put(species, speciesLengthForYears);
            }
            String year = tuple[2];
            setYear.add(year);
            String nombreValue = tuple[8];
            try {
                Double nombreDouble = Double.valueOf(nombreValue);
                if (speciesLengthForYears.containsKey(year)) {
                    Double oldValue = (Double)speciesLengthForYears.get(year);
                    Double newValue = oldValue + nombreDouble;
                    speciesLengthForYears.put(year, newValue);
                    continue;
                }
                speciesLengthForYears.put(year, nombreDouble);
            }
            catch (NumberFormatException ex) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Can't parse " + nombreValue + " as double"));
            }
        }
        for (Map.Entry catchEntries : catchForSpeciesYears.entrySet()) {
            String species = (String)catchEntries.getKey();
            Map catchNumbers = (Map)catchEntries.getValue();
            Map lengthNumbers = (Map)lengthForSpeciesYears.get(species);
            if (lengthNumbers == null) continue;
            for (String year : setYear) {
                double max;
                double diff;
                Double catchNumber = (Double)catchNumbers.get(year);
                Double lengthNumber = (Double)lengthNumbers.get(year);
                if (catchNumber == null) {
                    catchNumber = 0.0;
                }
                if (lengthNumber == null) {
                    lengthNumber = 0.0;
                }
                if (lengthNumber == 0.0 && catchNumber > 0.0 && !missingYearLengthSpecies.contains(species)) {
                    SpeciesControlError error = new SpeciesControlError();
                    error.setSpecies(species);
                    error.setLevel(CoserConstants.ValidationLevel.WARNING);
                    error.setMessage(I18n.t((String)"coser.business.control.error.diffCatchLengthMissingYear", (Object[])new Object[0]));
                    error.setDetailMessage(I18n.t((String)"coser.business.control.error.diffCatchLengthMissingYearDetail", (Object[])new Object[]{project.getDisplaySpeciesText(species)}));
                    validationErrors.add(error);
                    missingYearLengthSpecies.add(species);
                    continue;
                }
                double min = Math.min(catchNumber, lengthNumber);
                if (!(min > 0.0) || !((diff = ((max = Math.max(catchNumber, lengthNumber)) - min) * 100.0 / max) > this.config.getControlDiffCatchLength())) continue;
                DiffCatchLengthControlError error = new DiffCatchLengthControlError();
                error.setSpecies(species);
                error.setLevel(CoserConstants.ValidationLevel.WARNING);
                error.setMessage(I18n.t((String)"coser.business.control.error.diffCatchLength", (Object[])new Object[0]));
                error.setDetailMessage(I18n.t((String)"coser.business.control.error.diffCatchLengthDetail", (Object[])new Object[]{project.getDisplaySpeciesText(species), year}));
                validationErrors.add(error);
            }
        }
        Collections.sort(validationErrors);
        return validationErrors;
    }

    protected List<ControlError> validateCategorySpecificLength(Project project, Control control, ProgressMonitor progress) {
        Double newValue;
        Double oldValue;
        Double nombre;
        String lengthValue;
        ArrayList<ControlError> validationErrors = new ArrayList<ControlError>();
        int total = control.getLength().size() - 1;
        if (progress != null) {
            progress.setText(I18n.t((String)"coser.business.control.step.observation", (Object[])new Object[]{I18n.t((String)CoserConstants.Category.LENGTH.getTranslationKey(), (Object[])new Object[0]), 0}));
            progress.setTotal(total);
        }
        HashMap<String, Double> nombreForKey = new HashMap<String, Double>();
        HashMap<String, String> firstLineForKey = new HashMap<String, String>();
        HashMap<String, Double> lengthSumForSpecies = new HashMap<String, Double>();
        HashMap<String, Double> lengthCountForSpecies = new HashMap<String, Double>();
        Iterator<String[]> itTuple = control.getLength().iterator(true);
        int lineIndex = 1;
        while (itTuple.hasNext()) {
            String[] tuple;
            block25: {
                tuple = itTuple.next();
                if (progress != null) {
                    int progressPercent = (int)((double)lineIndex / (double)total * 100.0);
                    progress.setText(I18n.t((String)"coser.business.control.step.observation", (Object[])new Object[]{I18n.t((String)CoserConstants.Category.LENGTH.getTranslationKey(), (Object[])new Object[0]), progressPercent}));
                    progress.setCurrent(lineIndex);
                    ++lineIndex;
                }
                StringBuilder sb = new StringBuilder();
                for (int tupleIndex = 0; tupleIndex < tuple.length; ++tupleIndex) {
                    if (tupleIndex != 2 && tupleIndex != 3 && tupleIndex != 4) continue;
                    sb.append(tuple[tupleIndex]).append(';');
                }
                String nombreValue = tuple[8];
                String lineNumber = tuple[0];
                try {
                    Double nombre2 = Double.valueOf(nombreValue);
                    String key = sb.toString();
                    if (nombreForKey.containsKey(key)) {
                        Double oldValue2 = (Double)nombreForKey.get(key);
                        Double newValue2 = oldValue2 + nombre2;
                        nombreForKey.put(key, newValue2);
                    } else {
                        nombreForKey.put(key, nombre2);
                        firstLineForKey.put(key, lineNumber);
                    }
                }
                catch (NumberFormatException ex) {
                    if (!log.isWarnEnabled()) break block25;
                    log.warn((Object)("Can't parse " + nombreValue + " as double"));
                }
            }
            lengthValue = tuple[7];
            try {
                nombre = Double.valueOf(lengthValue);
                String key = tuple[4];
                if (lengthSumForSpecies.containsKey(key)) {
                    oldValue = (Double)lengthSumForSpecies.get(key);
                    newValue = oldValue + nombre;
                    lengthSumForSpecies.put(key, newValue);
                    Double count = (Double)lengthCountForSpecies.get(key);
                    lengthCountForSpecies.put(key, count + 1.0);
                    continue;
                }
                lengthSumForSpecies.put(key, nombre);
                lengthCountForSpecies.put(key, 1.0);
            }
            catch (NumberFormatException ex) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Can't parse " + lengthValue + " as double"));
            }
        }
        for (Map.Entry sumObservation : nombreForKey.entrySet()) {
            String key = (String)sumObservation.getKey();
            Double value = (Double)sumObservation.getValue();
            if (!(value < this.config.getControlNobsmin())) continue;
            String lineNumber = (String)firstLineForKey.get(key);
            ControlError error = new ControlError();
            error.setCategory(CoserConstants.Category.LENGTH);
            error.setLevel(CoserConstants.ValidationLevel.WARNING);
            error.addLineNumber(lineNumber);
            error.setMessage(I18n.t((String)"coser.business.control.error.minObservationCount", (Object[])new Object[0]));
            error.setDetailMessage(I18n.t((String)"coser.business.control.error.minObservationCountDetail", (Object[])new Object[]{key, value}));
            validationErrors.add(error);
        }
        if (progress != null) {
            progress.nextStep();
            progress.setTotal(total * 2);
        }
        HashMap avgForSpecies = new HashMap();
        for (Map.Entry entry : lengthSumForSpecies.entrySet()) {
            double avg = (Double)entry.getValue() / (Double)lengthCountForSpecies.get(entry.getKey());
            avgForSpecies.put(entry.getKey(), avg);
        }
        HashMap<String, Double> varianceSumForSpecies = new HashMap<String, Double>();
        itTuple = control.getLength().iterator(true);
        lineIndex = 1;
        while (itTuple.hasNext()) {
            if (progress != null) {
                int progressPercent = (int)((double)lineIndex / (double)total * 50.0);
                progress.setText(I18n.t((String)"coser.business.control.step.lengthdeviation", (Object[])new Object[]{I18n.t((String)CoserConstants.Category.LENGTH.getTranslationKey(), (Object[])new Object[0]), progressPercent}));
                progress.setCurrent(lineIndex);
                ++lineIndex;
            }
            String[] tuple = itTuple.next();
            String lengthValue2 = tuple[7];
            try {
                String key = tuple[4];
                nombre = Double.valueOf(lengthValue2);
                Double value = Math.pow(nombre - (Double)avgForSpecies.get(key), 2.0);
                if (varianceSumForSpecies.containsKey(key)) {
                    oldValue = (Double)varianceSumForSpecies.get(key);
                    newValue = oldValue + value;
                    varianceSumForSpecies.put(key, newValue);
                    continue;
                }
                varianceSumForSpecies.put(key, value);
            }
            catch (NumberFormatException ex) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Can't parse " + lengthValue2 + " as double"));
            }
        }
        HashMap deviationForSpecies = new HashMap();
        for (Map.Entry entry : varianceSumForSpecies.entrySet()) {
            double avg = Math.sqrt((Double)entry.getValue() / (Double)lengthCountForSpecies.get(entry.getKey()));
            deviationForSpecies.put(entry.getKey(), avg);
        }
        itTuple = control.getLength().iterator(true);
        lineIndex = 1;
        while (itTuple.hasNext()) {
            if (progress != null) {
                int progressPercent = (int)((double)lineIndex / (double)total * 50.0 + 50.0);
                progress.setText(I18n.t((String)"coser.business.control.step.lengthoutliers", (Object[])new Object[]{I18n.t((String)CoserConstants.Category.LENGTH.getTranslationKey(), (Object[])new Object[0]), progressPercent}));
                progress.setCurrent(total + lineIndex);
                ++lineIndex;
            }
            String[] tuple = itTuple.next();
            lengthValue = tuple[7];
            try {
                String species = tuple[4];
                Double nombre3 = Double.valueOf(lengthValue);
                Double avg = (Double)avgForSpecies.get(species);
                Double deviation = (Double)deviationForSpecies.get(species);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Species %s, avg=%f, deviation=%f, value=%f", species, avg, deviation, nombre3));
                }
                if (!(Math.abs(nombre3 - avg) > deviation * (double)this.config.getStandardDeviationToAverage())) continue;
                String lineNumber = tuple[0];
                SpeciesLengthControlError error = new SpeciesLengthControlError();
                error.setCategory(CoserConstants.Category.LENGTH);
                error.setLevel(CoserConstants.ValidationLevel.WARNING);
                error.addLineNumber(lineNumber);
                error.setSpecies(species);
                error.setMessage(I18n.t((String)"coser.business.control.error.lengthOutliers", (Object[])new Object[]{avg, deviation}));
                error.setDetailMessage(I18n.t((String)"coser.business.control.error.lengthOutliersDetail", (Object[])new Object[]{project.getDisplaySpeciesText(species), avg, deviation, lengthValue}));
                validationErrors.add(error);
            }
            catch (NumberFormatException ex) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Can't parse " + lengthValue + " as double"));
            }
        }
        return validationErrors;
    }

    protected List<ControlError> validateCategorySpecificHaul(Project project, Control control, ProgressMonitor progress) {
        return null;
    }

    protected List<ControlError> validateCategorySpecificStrata(Project project, Control control, ProgressMonitor progress) {
        return null;
    }

    protected List<ControlError> validationCrossFiles(Project project, Control control, ProgressMonitor progress) {
        ControlError error;
        String species;
        int total = control.getCatch().size() + control.getHaul().size() + control.getStrata().size() + control.getLength().size() - 4;
        if (progress != null) {
            progress.setText(I18n.t((String)"coser.business.control.step.crossFileChech", (Object[])new Object[]{0}));
            progress.setTotal(total);
            progress.setCurrent(0);
        }
        ArrayList<ControlError> crossFilesErrors = new ArrayList<ControlError>();
        Iterator<String[]> itReftax = project.getRefTaxSpecies().iterator(true);
        Iterator<String[]> itCatch = control.getCatch().iterator(true);
        Iterator<String[]> itLength = control.getLength().iterator(true);
        Iterator<String[]> itStrata = control.getStrata().iterator(true);
        Iterator<String[]> itHaul = control.getHaul().iterator(true);
        HashMap<String, Integer> refTaxSpecies = new HashMap<String, Integer>();
        HashSet<String> catchYear = new HashSet<String>();
        HashSet<String> lengthYear = new HashSet<String>();
        HashSet<String> haulYear = new HashSet<String>();
        HashSet<String> surveyNames = new HashSet<String>();
        HashSet<String> strataStrataNames = new HashSet<String>();
        HashSet<String> haulStrataNames = new HashSet<String>();
        HashSet<String> haulHaulNames = new HashSet<String>();
        HashSet<String> catchHaulNames = new HashSet<String>();
        HashSet<String> lengthHaulNames = new HashSet<String>();
        HashSet<String> catchSpeciesNames = new HashSet<String>();
        HashSet<String> lengthSpeciesNames = new HashSet<String>();
        HashSet<String> lengthYearHaulSpecies = new HashSet<String>();
        HashSet<String> catchYearHaulSpecies = new HashSet<String>();
        HashSet<String> haulYearHaul = new HashSet<String>();
        HashSet<String> lengthYearHaul = new HashSet<String>();
        HashSet<String> catchYearHaul = new HashSet<String>();
        HashMap<String, Integer[]> specyTypes = new HashMap<String, Integer[]>();
        while (itReftax.hasNext()) {
            String[] tuple = itReftax.next();
            String speciesId = null;
            switch (project.getStorageSpeciesType()) {
                case C_PERM: {
                    speciesId = tuple[0];
                    break;
                }
                case C_Valide: {
                    speciesId = tuple[3];
                    break;
                }
                case L_Valide: {
                    speciesId = tuple[4];
                }
            }
            Integer iNumSys = Integer.valueOf(tuple[1]);
            refTaxSpecies.put(speciesId, iNumSys);
        }
        Iterator<String[]> itTypeSpecies = project.getTypeEspeces().iterator(true);
        while (itTypeSpecies.hasNext()) {
            String[] tuple = itTypeSpecies.next();
            String specyType = tuple[0];
            Integer iMinNumSys = Integer.valueOf(tuple[2]);
            Integer iMaxNumSys = Integer.valueOf(tuple[3]);
            specyTypes.put(specyType, new Integer[]{iMinNumSys, iMaxNumSys});
        }
        int lineIndex = 1;
        while (itStrata.hasNext()) {
            if (progress != null) {
                int progressPercent = (int)((double)lineIndex / (double)total * 100.0);
                progress.setText(I18n.t((String)"coser.business.control.step.crossFileChech", (Object[])new Object[]{progressPercent}));
                progress.setCurrent(lineIndex);
                ++lineIndex;
            }
            String[] strataData = itStrata.next();
            surveyNames.add(strataData[1]);
            strataStrataNames.add(strataData[2]);
        }
        while (itHaul.hasNext()) {
            if (progress != null) {
                int progressPercent = (int)((double)lineIndex / (double)total * 100.0);
                progress.setText(I18n.t((String)"coser.business.control.step.crossFileChech", (Object[])new Object[]{progressPercent}));
                progress.setCurrent(lineIndex);
                ++lineIndex;
            }
            String[] haulData = itHaul.next();
            surveyNames.add(haulData[1]);
            haulYear.add(haulData[2]);
            haulYearHaul.add(haulData[2] + "|" + haulData[3]);
            haulStrataNames.add(haulData[5]);
            haulHaulNames.add(haulData[3]);
        }
        while (itCatch.hasNext()) {
            if (progress != null) {
                int progressPercent = (int)((double)lineIndex / (double)total * 100.0);
                progress.setText(I18n.t((String)"coser.business.control.step.crossFileChech", (Object[])new Object[]{progressPercent}));
                progress.setCurrent(lineIndex);
                ++lineIndex;
            }
            String[] catchData = itCatch.next();
            species = catchData[4];
            surveyNames.add(catchData[1]);
            catchYear.add(catchData[2]);
            catchYearHaulSpecies.add(catchData[2] + "|" + catchData[3] + "|" + project.getDisplaySpeciesText(species));
            catchYearHaul.add(catchData[2] + "|" + catchData[3]);
            catchHaulNames.add(catchData[3]);
            catchSpeciesNames.add(species);
            if (refTaxSpecies.containsKey(catchData[4])) continue;
            ControlError error3 = new ControlError();
            error3.setCategory(CoserConstants.Category.CATCH);
            error3.addLineNumber(catchData[0]);
            error3.setLevel(CoserConstants.ValidationLevel.ERROR);
            error3.setMessage(I18n.t((String)"coser.business.control.error.nonExistantSpecies", (Object[])new Object[0]));
            error3.setDetailMessage(I18n.t((String)"coser.business.control.error.nonExistantSpeciesDetail", (Object[])new Object[]{catchData[4]}));
            crossFilesErrors.add(error3);
        }
        while (itLength.hasNext()) {
            if (progress != null) {
                int progressPercent = (int)((double)lineIndex / (double)total * 100.0);
                progress.setText(I18n.t((String)"coser.business.control.step.crossFileChech", (Object[])new Object[]{progressPercent}));
                progress.setCurrent(lineIndex);
                ++lineIndex;
            }
            String[] lengthData = itLength.next();
            species = lengthData[4];
            surveyNames.add(lengthData[1]);
            lengthYear.add(lengthData[2]);
            lengthYearHaulSpecies.add(lengthData[2] + "|" + lengthData[3] + "|" + project.getDisplaySpeciesText(species));
            lengthYearHaul.add(lengthData[2] + "|" + lengthData[3]);
            lengthHaulNames.add(lengthData[3]);
            lengthSpeciesNames.add(species);
            if (!refTaxSpecies.containsKey(species)) {
                ControlError error2 = new ControlError();
                error2.setCategory(CoserConstants.Category.LENGTH);
                error2.addLineNumber(lengthData[0]);
                error2.setLevel(CoserConstants.ValidationLevel.ERROR);
                error2.setMessage(I18n.t((String)"coser.business.control.error.nonExistantSpecies", (Object[])new Object[0]));
                error2.setDetailMessage(I18n.t((String)"coser.business.control.error.nonExistantSpeciesDetail", (Object[])new Object[]{lengthData[4]}));
                crossFilesErrors.add(error2);
                continue;
            }
            Integer speciesNumSys = (Integer)refTaxSpecies.get(species);
            for (Map.Entry entry : specyTypes.entrySet()) {
                String speciesType = (String)entry.getKey();
                Integer[] bound = (Integer[])entry.getValue();
                if (!speciesType.equals(this.config.getControlTypeFish()) || speciesNumSys < bound[0] || speciesNumSys > bound[1] || this.isValidFishLength(lengthData[7])) continue;
                ControlError error3 = new ControlError();
                error3.setCategory(CoserConstants.Category.LENGTH);
                error3.addLineNumber(lengthData[0]);
                error3.setLevel(CoserConstants.ValidationLevel.WARNING);
                error3.setMessage(I18n.t((String)"coser.business.control.error.invalidLengthLengthStep", (Object[])new Object[0]));
                error3.setDetailMessage(I18n.t((String)"coser.business.control.error.invalidLengthLengthStepDetail", (Object[])new Object[]{lengthData[7], project.getDisplaySpeciesText(species)}));
                error3.setTipMessage(I18n.t((String)"coser.business.control.error.invalidLengthLengthStepTip", (Object[])new Object[0]));
                crossFilesErrors.add(error3);
            }
        }
        if (!catchYear.equals(lengthYear) || !haulYear.equals(lengthYear)) {
            error = new ControlError();
            error.setLevel(CoserConstants.ValidationLevel.FATAL);
            error.setMessage(I18n.t((String)"coser.business.control.error.yearsNotEquals", (Object[])new Object[0]));
            crossFilesErrors.add(error);
        }
        if (surveyNames.size() != 1) {
            error = new ControlError();
            error.setLevel(CoserConstants.ValidationLevel.FATAL);
            error.setMessage(I18n.t((String)"coser.business.control.error.surveyNotEquals", (Object[])new Object[0]));
            crossFilesErrors.add(error);
        }
        Collection missingSpeciesCatchTuples = CollectionUtils.subtract(lengthYearHaulSpecies, catchYearHaulSpecies);
        for (String missingSpeciesCatchTuple : missingSpeciesCatchTuples) {
            ControlError error4 = new ControlError();
            error4.setLevel(CoserConstants.ValidationLevel.FATAL);
            error4.setMessage(I18n.t((String)"coser.business.control.error.missingYearHaulSpeciesForCatchData", (Object[])new Object[0]));
            error4.setDetailMessage(I18n.t((String)"coser.business.control.error.missingYearHaulSpeciesForCatchDataDetail", (Object[])new Object[]{missingSpeciesCatchTuple}));
            error4.setTipMessage(I18n.t((String)"coser.business.control.error.missingYearHaulSpeciesForCatchDataTip", (Object[])new Object[0]));
            crossFilesErrors.add(error4);
        }
        Collection missingHaulLengthTuples = CollectionUtils.subtract(lengthYearHaul, haulYearHaul);
        for (String missingHaulLengthTuple : missingHaulLengthTuples) {
            ControlError controlError = new ControlError();
            controlError.setLevel(CoserConstants.ValidationLevel.FATAL);
            controlError.setMessage(I18n.t((String)"coser.business.control.error.missingYearHaulForLengthData", (Object[])new Object[0]));
            controlError.setDetailMessage(I18n.t((String)"coser.business.control.error.missingYearHaulForLengthDataDetail", (Object[])new Object[]{missingHaulLengthTuple}));
            controlError.setTipMessage(I18n.t((String)"coser.business.control.error.missingYearHaulForLengthDataTip", (Object[])new Object[0]));
            crossFilesErrors.add(controlError);
        }
        Collection missingHaulCatchTuples = CollectionUtils.subtract(catchYearHaul, haulYearHaul);
        for (String string : missingHaulCatchTuples) {
            ControlError error6 = new ControlError();
            error6.setLevel(CoserConstants.ValidationLevel.FATAL);
            error6.setMessage(I18n.t((String)"coser.business.control.error.missingYearHaulForCatchData", (Object[])new Object[0]));
            error6.setDetailMessage(I18n.t((String)"coser.business.control.error.missingYearHaulForCatchDataDetail", (Object[])new Object[]{string}));
            error6.setTipMessage(I18n.t((String)"coser.business.control.error.missingYearHaulForCatchDataTip", (Object[])new Object[0]));
            crossFilesErrors.add(error6);
        }
        Collection missingStrataStrataNames = CollectionUtils.subtract(haulStrataNames, strataStrataNames);
        for (String missingStrataStrataName : missingStrataStrataNames) {
            ControlError error7 = new ControlError();
            error7.setLevel(CoserConstants.ValidationLevel.FATAL);
            error7.setMessage(I18n.t((String)"coser.business.control.error.missingStrataStrataFromHaul", (Object[])new Object[0]));
            error7.setDetailMessage(I18n.t((String)"coser.business.control.error.missingStrataStrataFromHaulDetail", (Object[])new Object[]{missingStrataStrataName}));
            error7.setTipMessage(I18n.t((String)"coser.business.control.error.missingStrataStrataFromHaulTip", (Object[])new Object[0]));
            crossFilesErrors.add(error7);
        }
        Collection collection = CollectionUtils.subtract(strataStrataNames, haulStrataNames);
        for (String missingHaulStrataStrataName : collection) {
            ControlError error2 = new ControlError();
            error2.setLevel(CoserConstants.ValidationLevel.WARNING);
            error2.setMessage(I18n.t((String)"coser.business.control.error.missingHaulStrataFromStrata", (Object[])new Object[0]));
            error2.setDetailMessage(I18n.t((String)"coser.business.control.error.missingHaulStrataFromStrataDetail", (Object[])new Object[]{missingHaulStrataStrataName}));
            error2.setTipMessage(I18n.t((String)"coser.business.control.error.missingHaulStrataFromStrataTip", (Object[])new Object[0]));
            crossFilesErrors.add(error2);
        }
        Collection missingHaulHaulNames = CollectionUtils.subtract(catchHaulNames, haulHaulNames);
        for (String missingHaulHaulName : missingHaulHaulNames) {
            ControlError error8 = new ControlError();
            error8.setLevel(CoserConstants.ValidationLevel.FATAL);
            error8.setMessage(I18n.t((String)"coser.business.control.error.missingHaulHaulFromCatch", (Object[])new Object[0]));
            error8.setDetailMessage(I18n.t((String)"coser.business.control.error.missingHaulHaulFromCatchDetail", (Object[])new Object[]{missingHaulHaulName}));
            error8.setTipMessage(I18n.t((String)"coser.business.control.error.missingHaulHaulFromCatchTip", (Object[])new Object[0]));
            crossFilesErrors.add(error8);
        }
        Collection missingCatchHaulNames = CollectionUtils.subtract(haulHaulNames, catchHaulNames);
        for (String missingCatchHaulName : missingCatchHaulNames) {
            ControlError error9 = new ControlError();
            error9.setLevel(CoserConstants.ValidationLevel.WARNING);
            error9.setMessage(I18n.t((String)"coser.business.control.error.missingCatchHaulFromHaul", (Object[])new Object[0]));
            error9.setDetailMessage(I18n.t((String)"coser.business.control.error.missingCatchHaulFromHaulDetail", (Object[])new Object[]{missingCatchHaulName}));
            error9.setTipMessage(I18n.t((String)"coser.business.control.error.missingCatchHaulFromHaulTip", (Object[])new Object[0]));
            crossFilesErrors.add(error9);
        }
        Collection missingCatchHaulForLengthNames = CollectionUtils.subtract(lengthHaulNames, catchHaulNames);
        for (String missingCatchHaulForLengthName : missingCatchHaulForLengthNames) {
            ControlError error10 = new ControlError();
            error10.setLevel(CoserConstants.ValidationLevel.FATAL);
            error10.setMessage(I18n.t((String)"coser.business.control.error.missingCatchHaulFromLength", (Object[])new Object[0]));
            error10.setDetailMessage(I18n.t((String)"coser.business.control.error.missingCatchHaulFromLengthDetail", (Object[])new Object[]{missingCatchHaulForLengthName}));
            error10.setTipMessage(I18n.t((String)"coser.business.control.error.missingCatchHaulFromLengthTip", (Object[])new Object[0]));
            crossFilesErrors.add(error10);
        }
        Collection missingLengthHaulNames = CollectionUtils.subtract(catchHaulNames, lengthHaulNames);
        for (String missingLengthHaulName : missingLengthHaulNames) {
            ControlError error11 = new ControlError();
            error11.setLevel(CoserConstants.ValidationLevel.WARNING);
            error11.setMessage(I18n.t((String)"coser.business.control.error.missingLengthHaulFromCatch", (Object[])new Object[0]));
            error11.setDetailMessage(I18n.t((String)"coser.business.control.error.missingLengthHaulFromCatchDetail", (Object[])new Object[]{missingLengthHaulName}));
            error11.setTipMessage(I18n.t((String)"coser.business.control.error.missingLengthHaulFromCatchTip", (Object[])new Object[0]));
            crossFilesErrors.add(error11);
        }
        Collection missingCatchSpeciesNames = CollectionUtils.subtract(lengthSpeciesNames, catchSpeciesNames);
        for (String missingCatchSpeciesName : missingCatchSpeciesNames) {
            SpeciesControlError error12 = new SpeciesControlError();
            error12.setLevel(CoserConstants.ValidationLevel.FATAL);
            error12.setSpecies(missingCatchSpeciesName);
            error12.setMessage(I18n.t((String)"coser.business.control.error.missingCatchSpeciesFromLength", (Object[])new Object[0]));
            error12.setDetailMessage(I18n.t((String)"coser.business.control.error.missingCatchSpeciesFromLengthDetail", (Object[])new Object[]{project.getDisplaySpeciesText(missingCatchSpeciesName)}));
            error12.setTipMessage(I18n.t((String)"coser.business.control.error.missingCatchSpeciesFromLengthTip", (Object[])new Object[0]));
            crossFilesErrors.add(error12);
        }
        Collection missingLengthSpeciesNames = CollectionUtils.subtract(catchSpeciesNames, lengthSpeciesNames);
        for (String missingLengthSpeciesName : missingLengthSpeciesNames) {
            SpeciesControlError error13 = new SpeciesControlError();
            error13.setLevel(CoserConstants.ValidationLevel.WARNING);
            error13.setSpecies(missingLengthSpeciesName);
            error13.setMessage(I18n.t((String)"coser.business.control.error.missingLengthSpeciesFromCatch", (Object[])new Object[0]));
            error13.setDetailMessage(I18n.t((String)"coser.business.control.error.missingLengthSpeciesFromCatchDetail", (Object[])new Object[]{project.getDisplaySpeciesText(missingLengthSpeciesName)}));
            error13.setTipMessage(I18n.t((String)"coser.business.control.error.missingLengthSpeciesFromCatchTip", (Object[])new Object[0]));
            crossFilesErrors.add(error13);
        }
        return crossFilesErrors;
    }

    protected boolean isValidFishLength(String length) {
        Matcher mLength = FISH_LENGTH_PATTERN.matcher(length);
        return mLength.matches();
    }
}

