/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.result.repository.legacy.command;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import fr.ifremer.coser.result.repository.legacy.LegacyPredicates;
import fr.ifremer.coser.result.repository.legacy.command.AbstractLegacyCommand;
import fr.ifremer.coser.result.request.GetSpeciesListForCommunityIndicatorResultRequest;
import fr.ifremer.coser.result.result.MapResult;
import fr.ifremer.coser.storage.DataStorageWalker;
import java.util.LinkedHashSet;
import java.util.Map;

public class GetSpeciesListForCommunityIndicatorResultCommand
extends AbstractLegacyCommand<GetSpeciesListForCommunityIndicatorResultRequest> {
    @Override
    public boolean accept(GetSpeciesListForCommunityIndicatorResultRequest request) {
        boolean result;
        boolean bl = result = this.repository.isIndicatorsResult() && this.repository.matchFacade(request) && this.repository.matchZone(request);
        if (result) {
            Predicate<String[]> predicate = LegacyPredicates.communityIndicatorPredicate(request.getIndicator());
            result = this.repository.matchCommunity(predicate);
        }
        return result;
    }

    public MapResult execute(GetSpeciesListForCommunityIndicatorResultRequest request) {
        final LinkedHashSet speciesList = Sets.newLinkedHashSet();
        DataStorageWalker walker = new DataStorageWalker(){

            @Override
            public void onRow(String ... tuple) {
                String speciesListCode = tuple[2];
                speciesList.add(speciesListCode);
            }
        };
        Predicate<String[]> predicate = LegacyPredicates.communityIndicatorPredicate(request.getIndicator());
        this.walkOnCommunity(predicate, walker);
        Map<String, String> map = this.repository.getSpeciesListMap().getSpeciesSubMap(this.getLocale(), speciesList);
        MapResult result = this.newMapResult(map);
        return result;
    }
}

