/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.result.repository.legacy.command;

import fr.ifremer.coser.CoserTechnicalException;
import fr.ifremer.coser.result.CoserResult;
import fr.ifremer.coser.result.repository.legacy.command.AbstractLegacyCommand;
import fr.ifremer.coser.result.request.DeleteResultsRequest;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeleteResultsCommand
extends AbstractLegacyCommand<DeleteResultsRequest> {
    private static final Log log = LogFactory.getLog(DeleteResultsCommand.class);

    @Override
    public boolean accept(DeleteResultsRequest request) {
        boolean result = this.repository.matchRepositoryType(request) && this.repository.matchResultType(request) && this.repository.isPubliableResult() && this.repository.matchZone(request);
        return result;
    }

    @Override
    public CoserResult execute(DeleteResultsRequest request) {
        File basedir = this.repository.getBasedir();
        if (log.isInfoEnabled()) {
            log.info((Object)("Will delete project at: " + basedir));
        }
        try {
            FileUtils.deleteDirectory((File)basedir);
        }
        catch (IOException e) {
            throw new CoserTechnicalException("Could not delete project at: " + basedir, e);
        }
        return this.newVoidResult();
    }
}

