/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.result.repository.echobase;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.coser.bean.EchoBaseProject;
import fr.ifremer.coser.result.ResultRepositoryInitializationException;
import fr.ifremer.coser.result.repository.ResultRepositoryProvider;
import fr.ifremer.coser.result.repository.echobase.EchoBaseResultRepository;
import fr.ifremer.coser.result.repository.echobase.EchoBaseResultRepositoryType;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EchoBaseResultRepositoryProvider
implements ResultRepositoryProvider<EchoBaseResultRepository> {
    private static final Log log = LogFactory.getLog(EchoBaseResultRepositoryProvider.class);
    protected final File basedir;

    public EchoBaseResultRepositoryProvider(File basedir) {
        Preconditions.checkNotNull((Object)basedir);
        this.basedir = basedir;
    }

    @Override
    public EchoBaseResultRepositoryType getRepositoryType() {
        return EchoBaseResultRepositoryType.INSTANCE;
    }

    @Override
    public Set<EchoBaseResultRepository> loadRepositories() {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Scan for projects from basedir: %s", this.basedir));
        }
        HashSet result = Sets.newHashSet();
        AndFileFilter projectFilter = new AndFileFilter();
        projectFilter.addFileFilter(FileFilterUtils.directoryFileFilter());
        projectFilter.addFileFilter((IOFileFilter)new AbstractFileFilter(){

            public boolean accept(File pathname) {
                return new File(pathname, "project.echobase").exists();
            }
        });
        File[] projects = this.basedir.listFiles((FileFilter)projectFilter);
        if (projects != null) {
            for (File projectDirectory : projects) {
                EchoBaseProject project = new EchoBaseProject(projectDirectory);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Detected result: %s", project.getName()));
                }
                try {
                    project.load();
                }
                catch (IOException e) {
                    throw new ResultRepositoryInitializationException(this, "Could not load project file", e);
                }
                result.add(new EchoBaseResultRepository(project));
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Found %s result repository(ies) from basedir: %s", result.size(), this.basedir));
        }
        return result;
    }
}

