/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.bean;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.coser.storage.DataStorage;
import fr.ifremer.coser.storage.DataStorageWalker;
import fr.ifremer.coser.storage.DataStorages;
import fr.ifremer.coser.storage.MemoryDataStorage;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZoneMap
implements Serializable {
    private static final Log log = LogFactory.getLog(ZoneMap.class);
    private static final long serialVersionUID = 1L;
    protected final DataStorage storage;

    public ZoneMap(File zonesFile) {
        if (zonesFile == null || zonesFile.isFile()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Using zone file: " + zonesFile));
            }
            this.storage = DataStorages.load(zonesFile);
        } else {
            this.storage = new MemoryDataStorage();
        }
    }

    public String getZoneFullName(String zoneId) {
        String resultName = null;
        int zoneIndex = this.storage.indexOf(zoneId);
        if (zoneIndex != -1) {
            String[] tuple = this.storage.get(zoneIndex);
            resultName = tuple[2];
            resultName = resultName + " - " + tuple[3];
            resultName = resultName + " - " + tuple[4];
            resultName = resultName + " - " + tuple[5];
        }
        return resultName;
    }

    public String getZoneFullNameWithNoFacade(String zoneId) {
        String resultName = null;
        int zoneIndex = this.storage.indexOf(zoneId);
        if (zoneIndex != -1) {
            String[] tuple = this.storage.get(zoneIndex);
            resultName = tuple[3];
            resultName = resultName + " - " + tuple[4];
            resultName = resultName + " - " + tuple[5];
        }
        return resultName;
    }

    public Map<String, String> getZoneMetaInfo(Locale locale) {
        HashMap<String, String> result = new HashMap<String, String>();
        GetZoneMetaInfoWalker walker = new GetZoneMetaInfoWalker(locale, result);
        DataStorages.walk(this.storage, walker);
        return result;
    }

    public Map<String, String> getZonePictures() {
        HashMap<String, String> result = new HashMap<String, String>();
        GetZonePictureWalker walker = new GetZonePictureWalker(result);
        DataStorages.walk(this.storage, walker);
        return result;
    }

    public Map<String, List<String>> getZoneByFacade() {
        HashMap<String, List<String>> zonesByFacade = new HashMap<String, List<String>>();
        GetZoneByFacadeWalker walker = new GetZoneByFacadeWalker(zonesByFacade);
        DataStorages.walk(this.storage, walker);
        return zonesByFacade;
    }

    public Map<String, String> getFacades() {
        LinkedHashMap<String, String> facades = new LinkedHashMap<String, String>();
        GetFacadesWalker walker = new GetFacadesWalker(facades);
        DataStorages.walk(this.storage, walker);
        return facades;
    }

    public List<String> getZonesForFacade(String facade) {
        ArrayList facades = Lists.newArrayList();
        GetZonesForFacadeWalker walker = new GetZonesForFacadeWalker(facade, facades);
        FacadeNameOrAllPredicate predicate = new FacadeNameOrAllPredicate(facade);
        DataStorages.walk(this.storage, predicate, walker);
        return facades;
    }

    public DataStorage getStorage() {
        return this.storage;
    }

    public Map<String, String> getSubZonesMap(String zoneId, List<String> allowedZones) {
        HashMap result = Maps.newHashMap();
        if (allowedZones != null && allowedZones.contains(zoneId)) {
            String zoneFullName = this.getZoneFullNameWithNoFacade(zoneId);
            result.put(zoneId, zoneFullName);
        }
        return result;
    }

    protected static class FacadeNameOrAllPredicate
    implements Predicate<String[]> {
        private final String facade;

        public FacadeNameOrAllPredicate(String facade) {
            this.facade = facade;
        }

        public boolean apply(String[] input) {
            return this.facade == null || input[1].equals(this.facade);
        }
    }

    protected static class GetZoneByFacadeWalker
    implements DataStorageWalker {
        protected final Map<String, List<String>> zonesByFacade;

        public GetZoneByFacadeWalker(Map<String, List<String>> zonesByFacade) {
            this.zonesByFacade = zonesByFacade;
        }

        @Override
        public void onRow(String ... tuple) {
            String facadeid = tuple[1];
            String zoneid = tuple[0];
            List<String> zones = this.zonesByFacade.get(facadeid);
            if (zones == null) {
                zones = new ArrayList<String>();
                this.zonesByFacade.put(facadeid, zones);
            }
            zones.add(zoneid);
        }
    }

    protected static class GetZoneMetaInfoWalker
    implements DataStorageWalker {
        protected final Map<String, String> result;
        protected final int localeIndex;

        public GetZoneMetaInfoWalker(Locale locale, Map<String, String> result) {
            this.result = result;
            this.localeIndex = locale != null && "fr".equals(locale.getLanguage()) ? 6 : (locale != null && "es".equals(locale.getLanguage()) ? 8 : 7);
        }

        @Override
        public void onRow(String ... tuple) {
            this.result.put(tuple[0], tuple[this.localeIndex]);
        }
    }

    protected static class GetFacadesWalker
    implements DataStorageWalker {
        protected final Map<String, String> facades;

        public GetFacadesWalker(Map<String, String> facades) {
            this.facades = facades;
        }

        @Override
        public void onRow(String ... tuple) {
            this.facades.put(tuple[1], tuple[2]);
        }
    }

    protected static class GetZonesForFacadeWalker
    implements DataStorageWalker {
        protected final String facade;
        protected final List<String> facades;

        public GetZonesForFacadeWalker(String facade, List<String> facades) {
            this.facade = facade;
            this.facades = facades;
        }

        @Override
        public void onRow(String ... tuple) {
            this.facades.add(tuple[0]);
        }
    }

    protected static class GetZonePictureWalker
    implements DataStorageWalker {
        protected final Map<String, String> result;

        public GetZonePictureWalker(Map<String, String> result) {
            this.result = result;
        }

        @Override
        public void onRow(String ... tuple) {
            String pictureName = tuple[9];
            String zoneId = tuple[0];
            this.result.put(zoneId, pictureName);
            if (StringUtils.isBlank((CharSequence)pictureName) && log.isWarnEnabled()) {
                log.warn((Object)String.format("No picture defined for zone: %s", zoneId));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("zone: %s -- picture: %s", zoneId, pictureName));
            }
        }
    }
}

