/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.bean;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.lang3.StringUtils;

public class EchoBaseProject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String METADATA_FILE = "project.echobase";
    protected final File basedir;
    protected String author;
    protected String facadeName;
    protected String zoneName;
    protected String surveyName;
    protected String comment;
    protected Date creationDate;
    protected boolean publiableResult;

    public EchoBaseProject(File basedir) {
        Preconditions.checkNotNull((Object)basedir);
        this.basedir = basedir;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public String getName() {
        return this.getBasedir().getName();
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getFacadeName() {
        return this.facadeName;
    }

    public void setFacadeName(String facadeName) {
        this.facadeName = facadeName;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public void setZoneName(String zoneName) {
        this.zoneName = zoneName;
    }

    public String getSurveyName() {
        return this.surveyName;
    }

    public void setSurveyName(String surveyName) {
        this.surveyName = surveyName;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public boolean isPubliableResult() {
        return this.publiableResult;
    }

    public void setPubliableResult(boolean publiableResult) {
        this.publiableResult = publiableResult;
    }

    public File getSpeciesDefinitionFile() {
        return new File(this.basedir, "species.csv");
    }

    public File getPopulationIndicatorsFile() {
        return new File(this.basedir, "populationIndicators.csv");
    }

    public File getCommunityIndicatorsFile() {
        return new File(this.basedir, "communityIndicators.csv");
    }

    public File getMapsDirectory() {
        return new File(this.basedir, "maps");
    }

    public File getRawDataDirectory() {
        return new File(this.basedir, "source");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        File metadataFile = this.getMetaDataFile();
        BufferedReader reader = Files.newReader((File)metadataFile, (Charset)Charsets.UTF_8);
        try {
            Properties p = new Properties();
            p.load(reader);
            ((Reader)reader).close();
            this.fromProperties(p);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        File metadataFile = this.getMetaDataFile();
        BufferedWriter writer = Files.newWriter((File)metadataFile, (Charset)Charsets.UTF_8);
        try {
            Properties p = this.toProperties();
            p.store(writer, "Saved by " + EchoBaseProject.class.getName());
            ((Writer)writer).close();
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EchoBaseProject)) {
            return false;
        }
        EchoBaseProject that = (EchoBaseProject)o;
        return this.basedir.equals(that.basedir);
    }

    public int hashCode() {
        return this.basedir.hashCode();
    }

    protected File getMetaDataFile() {
        return new File(this.basedir, METADATA_FILE);
    }

    protected Properties toProperties() {
        Properties props = new Properties();
        if (this.author != null) {
            props.setProperty("project.author", this.author);
        }
        if (this.facadeName != null) {
            props.setProperty("project.facadeName", this.facadeName);
        }
        if (this.zoneName != null) {
            props.setProperty("project.zoneName", this.zoneName);
        }
        if (this.surveyName != null) {
            props.setProperty("project.surveyName", this.surveyName);
        }
        if (this.comment != null) {
            props.setProperty("project.comment", this.comment);
        }
        if (this.creationDate != null) {
            props.setProperty("project.creationDate", String.valueOf(this.creationDate.getTime()));
        }
        props.setProperty("project.publiableResult", String.valueOf(this.publiableResult));
        return props;
    }

    protected void fromProperties(Properties props) {
        if (props.containsKey("project.author")) {
            this.setAuthor(props.getProperty("project.author"));
        }
        if (props.containsKey("project.facadeName")) {
            this.setFacadeName(props.getProperty("project.facadeName"));
        }
        if (props.containsKey("project.zoneName")) {
            this.setZoneName(props.getProperty("project.zoneName"));
        }
        if (props.containsKey("project.surveyName")) {
            this.setSurveyName(props.getProperty("project.surveyName"));
        }
        if (props.containsKey("project.comment")) {
            this.setComment(props.getProperty("project.comment"));
        }
        if (props.containsKey("project.creationDate")) {
            Date date = new Date(Long.parseLong(props.getProperty("project.creationDate")));
            this.setCreationDate(date);
        }
        if (props.containsKey("project.publiableResult")) {
            boolean v = Boolean.valueOf(props.getProperty("project.publiableResult"));
            this.setPubliableResult(v);
        }
    }

    public static FilenameFilter newMapSpeciesFilenameFilter(String surveyName) {
        RegexFileFilter result = new RegexFileFilter("^" + surveyName + "_[^_]+?\\.png");
        return result;
    }

    public static Function<File, String> newMapFileToSpeciesCode(String surveyName) {
        return new MapFileToSpeciesCodeFunction(surveyName);
    }

    public static Function<String, String> newSpeciesCodeToMapFileName(String surveyName) {
        return new SpeciesCodeToMapFileNameFunction(surveyName);
    }

    protected static class SpeciesCodeToMapFileNameFunction
    implements Function<String, String> {
        private final String zoneName;

        public SpeciesCodeToMapFileNameFunction(String zoneName) {
            this.zoneName = zoneName;
        }

        public String apply(String input) {
            String fileName = this.zoneName + "_" + input + ".png";
            return fileName;
        }
    }

    protected static class MapFileToSpeciesCodeFunction
    implements Function<File, String> {
        private final String zoneName;

        public MapFileToSpeciesCodeFunction(String zoneName) {
            this.zoneName = zoneName;
        }

        public String apply(File input) {
            String fileName = input.getName();
            String species = fileName.substring(this.zoneName.length() + 1);
            species = StringUtils.substringBefore((String)species, (String)".");
            return species;
        }
    }
}

