/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.services.v1;

import com.google.common.collect.Lists;
import fr.ifremer.coselmar.beans.CloudWord;
import fr.ifremer.coselmar.exceptions.CoselmarTechnicalException;
import fr.ifremer.coselmar.persistence.entity.CoselmarUserRole;
import fr.ifremer.coselmar.services.CoselmarWebServiceSupport;
import fr.ifremer.coselmar.services.indexation.TransverseIndexationService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.queryparser.classic.ParseException;

public class GeneralWebService
extends CoselmarWebServiceSupport {
    private static final Log log = LogFactory.getLog(GeneralWebService.class);
    protected static final List<String> RESTRICTED_ACCESS_USERS = Lists.newArrayList((Object[])new String[]{CoselmarUserRole.CLIENT.name(), CoselmarUserRole.MEMBER.name()});

    public List<CloudWord> getTopWords() {
        Map topTerms;
        block3: {
            TransverseIndexationService questionsIndexationService = (TransverseIndexationService)this.getServicesContext().newService(TransverseIndexationService.class);
            topTerms = null;
            try {
                topTerms = questionsIndexationService.getTopTerms();
            }
            catch (IOException | ParseException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Unable to search by lucene, make search directly in database", e);
                throw new CoselmarTechnicalException("Unable to get most frequecy words");
            }
        }
        ArrayList<CloudWord> cloudWords = new ArrayList<CloudWord>(topTerms.size());
        for (Map.Entry wordFrequency : topTerms.entrySet()) {
            CloudWord cloudWord = new CloudWord((String)wordFrequency.getKey(), ((Long)wordFrequency.getValue()).longValue());
            cloudWords.add(cloudWord);
        }
        return cloudWords;
    }
}

